package com.example.androidtest20200107.wifi;

import com.example.androidtest20200107.MyApp;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.WifiManager;
import android.widget.Toast;

public class WifiReceiver extends BroadcastReceiver {
    private WifiStateListener wifiStateListener;

    public void setWifiStateListener(WifiStateListener wifiStateListener) {
        this.wifiStateListener = wifiStateListener;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent.getAction() != null && intent.getAction().equals(WifiManager.WIFI_STATE_CHANGED_ACTION)) {
            switch (intent.getIntExtra(WifiManager.EXTRA_WIFI_STATE, WifiManager.WIFI_STATE_UNKNOWN)) {
                case WifiManager.WIFI_STATE_DISABLED: {
                    setWifiState(false);
                    Toast.makeText(MyApp.getInstance().getApplicationContext(), "已关闭WiFi", Toast.LENGTH_SHORT).show();
                    break;
                }
                case WifiManager.WIFI_STATE_DISABLING:
                    break;

                case WifiManager.WIFI_STATE_ENABLED: {
                    setWifiState(true);
                    Toast.makeText(MyApp.getInstance().getApplicationContext(), "已打开WiFi", Toast.LENGTH_SHORT).show();
                    break;
                }
                case WifiManager.WIFI_STATE_ENABLING:
                    break;

                case WifiManager.WIFI_STATE_UNKNOWN:
                    break;

            }
        }
        if (intent.getAction() != null && intent.getAction().equals("android.net.wifi.WIFI_AP_STATE_CHANGED")) {
            // 热点的状态为：10---正在关闭；11---已关闭；12---正在开启；13---已开启
            int state = intent.getIntExtra("wifi_state", 0);
            switch (state) {
                case 10:// 热点状态：正在关闭
                    break;
                case 11:// 热点状态：已关闭
                    setHotpotState(false);
                    break;
                case 12:// 热点状态：正在开启
                    break;
                case 13:// 热点状态：已开启
                    setHotpotState(true);
                    break;
            }
        }
    }

    public interface WifiStateListener {
        void onWifiOpen();

        void onWifiClose();

        void onHotpotOpen();

        void onHotpotClose();
    }

    private void setWifiState(boolean b) {
        if (wifiStateListener != null) {
            if (b) {
                wifiStateListener.onWifiOpen();
            } else {
                wifiStateListener.onWifiClose();
            }
        }
    }

    private void setHotpotState(boolean b) {
        if (wifiStateListener != null) {
            if (b) {
                wifiStateListener.onHotpotOpen();
            } else {
                wifiStateListener.onHotpotClose();
            }
        }
    }
}
