package com.example.androidtest20200107.wifi;

import com.example.androidtest20200107.MyApp;

import android.content.Context;
import android.net.wifi.WifiManager;

public class WifiUtils {
    /**
     * 打开或关闭wifi
     * <p>
     * 需添加权限 {@code <uses-permission android:name=
     * "android.permission.CHANGE_WIFI_STATE"/>}
     * </p>
     *
     * @param enabled {@code true}: 打开<br>
     *                {@code false}: 关闭
     */
    public static void setWifiEnabled(boolean enabled) {
        WifiManager wifiManager = (WifiManager) MyApp.getInstance().getApplicationContext()
                .getSystemService(Context.WIFI_SERVICE);
        if (enabled) {
            if (!wifiManager.isWifiEnabled()) {
                wifiManager.setWifiEnabled(true);
            }
        } else {
            if (wifiManager.isWifiEnabled()) {
                wifiManager.setWifiEnabled(false);
            }
        }
    }

    /**
     * 判断wifi是否打开
     * <p>
     * 需添加权限 {@code <uses-permission android:name=
     * "android.permission.ACCESS_WIFI_STATE"/>}
     * </p>
     *
     * @return {@code true}: 是<br>
     *         {@code false}: 否
     */
    public static boolean getWifiEnabled() {
        WifiManager wifiManager = (WifiManager) MyApp.getInstance().getApplicationContext()
                .getSystemService(Context.WIFI_SERVICE);
        return wifiManager.isWifiEnabled();
    }
}
