package com.nextbiometrics.biometrics;

import com.nextbiometrics.biometrics.jna.NBBiometricsIdentifyResultDetailsData;

public final class NBBiometricsIdentifyResult {
    private NBBiometricsStatus status;
    private Object templateId;
    private int score;

    NBBiometricsIdentifyResult(NBBiometricsStatus status, Object templateId, int score) {
        /* 22 */ this.status = status;
        /* 23 */ this.templateId = templateId;
        /* 24 */ this.score = score;
    }

    NBBiometricsIdentifyResult(NBBiometricsStatus status, Object templateId,
            NBBiometricsIdentifyResultDetailsData data) {
        /* 28 */ this(status, templateId, data.iScore);
    }

    public final NBBiometricsStatus getStatus() {
        /* 40 */ return this.status;
    }

    public final Object getTemplateId() {
        /* 48 */ return this.templateId;
    }

    public final int getScore() {
        /* 57 */ return this.score;
    }

    public String toString() {
        /* 66 */ return String.format("Status: %s, Template id: %s, Score: %d",
                new Object[] { this.status, this.templateId, Integer.valueOf(this.score) });
    }
}
