package com.nextbiometrics.biometrics.jna;

import com.nextbiometrics.biometrics.NBBiometricsContext;
import com.nextbiometrics.biometrics.NBBiometricsLibrary;
import com.nextbiometrics.biometrics.NBBiometricsStatus;
import com.nextbiometrics.biometrics.event.NBBiometricsScanPreviewEvent;
import com.nextbiometrics.biometrics.event.NBBiometricsScanPreviewListener;
import com.nextbiometrics.devices.NBDevice;
import com.nextbiometrics.devices.NBDeviceScanFormatInfo;
import com.nextbiometrics.devices.NBDeviceScanStatus;
import com.nextbiometrics.devices.jna.NBDeviceScanFormatInfoData;
import com.nextbiometrics.devices.jna.NBDeviceScanPreviewDetailsData;
import com.nextbiometrics.system.NBCallback;
import com.nextbiometrics.system.NBCallbackParam;
import com.nextbiometrics.system.NBCallbacks;
import com.nextbiometrics.system.NBErrors;
import com.nextbiometrics.system.jna.NBSizeType;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

public class NBBiometricsScanPreviewCallback {
    public static final NBBiometricsScanPreviewProc previewCallback = new NBBiometricsScanPreviewProc() {
        public int invoke(Pointer hContext, int eBiometricsStatus, Pointer hDevice, IntByReference peScanStatus,
                Pointer psScanFormat, Pointer pBuffer, NBSizeType stBufferSize, Pointer psDetails, NBSizeType pParam) {
            try {
                byte[] pImage = null;
                if (pBuffer != Pointer.NULL) {
                    pImage = pBuffer.getByteArray(0L, stBufferSize.intValue());
                }
                NBDeviceScanFormatInfo scanFormatInfo = null;
                if (psScanFormat != Pointer.NULL) {
                    NBDeviceScanFormatInfoData scanFormatInfoData = new NBDeviceScanFormatInfoData(psScanFormat);
                    scanFormatInfo = new NBDeviceScanFormatInfo(scanFormatInfoData);
                }
                int fingerDetectValue = 0;
                if (psDetails != Pointer.NULL) {
                    NBDeviceScanPreviewDetailsData previewDetails = new NBDeviceScanPreviewDetailsData(psDetails);
                    fingerDetectValue = previewDetails.iFingerDetectValue;
                }
                NBCallbackParam param = NBCallbacks.get(pParam.intValue());
                NBBiometricsScanPreviewEvent event = new NBBiometricsScanPreviewEvent(
                        new NBBiometricsContext(hContext, false), NBBiometricsStatus.get(eBiometricsStatus),
                        new NBDevice(hDevice, false), NBDeviceScanStatus.get(peScanStatus.getValue()), scanFormatInfo,
                        pImage, fingerDetectValue);
                ((NBBiometricsScanPreviewListener) param.getListener()).preview(event);
                peScanStatus.setValue(event.getScanStatus().getValue());
                return 0;
            } catch (Throwable th) {
                return NBErrors.setLast(th);
            }
        }
    };

    static {
        Native.register(NBBiometricsScanPreviewCallback.class, NBBiometricsLibrary.NATIVE_LIBRARY);
    }

    public static abstract interface NBBiometricsScanPreviewProc extends NBCallback {
        public abstract int invoke(Pointer paramPointer1, int paramInt, Pointer paramPointer2,
                IntByReference paramIntByReference, Pointer paramPointer3, Pointer paramPointer4,
                NBSizeType paramNBSizeType1, Pointer paramPointer5, NBSizeType paramNBSizeType2);
    }
}
