package com.nextbiometrics.biometrics.jna;

import com.nextbiometrics.biometrics.NBBiometricsLibrary;
import com.nextbiometrics.biometrics.NBBiometricsTemplate;
import com.nextbiometrics.system.NBCallback;
import com.nextbiometrics.system.NBErrors;
import com.nextbiometrics.system.jna.NBSizeType;
import com.nextbiometrics.system.jna.ptr.NBSizeTypeByReference;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;

public final class NBBiometricsTemplateIterator {
    private int currentIndex = 1;
    private HashMap<Integer, Object> templateIdMap = new HashMap();
    private Memory lastTemplatePointer = null;
    private Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> templates;
    private final NBBiometricsTemplateIteratorInitProc initCallback = new NBBiometricsTemplateIteratorInitProc() {
        public int invoke(NBSizeType pContext) {
            return 0;
        }
    };

    private final NBBiometricsTemplateIteratorTerminateProc terminateCallback = new NBBiometricsTemplateIteratorTerminateProc() {
        public int invoke(NBSizeType pContext) {
            try {
                return 0;
            } catch (Throwable th) {
                return NBErrors.setLast(th);
            }
        }
    };

    private final NBBiometricsTemplateIteratorNextTemplateProc nextCallback = new NBBiometricsTemplateIteratorNextTemplateProc() {
        public int invoke(NBSizeType pContext, NBSizeTypeByReference ppTemplateId, PointerByReference ppTemplate,
                NBSizeTypeByReference pstTemplateSize) {
            try {
                AbstractMap.SimpleEntry template = (AbstractMap.SimpleEntry) NBBiometricsTemplateIterator.this.templates
                        .next();

                /* 104 */ byte[] templateData = ((NBBiometricsTemplate) template.getValue()).getData();

                /* 106 */ NBBiometricsTemplateIterator.this.lastTemplatePointer = new Memory(templateData.length);
                /* 107 */ NBBiometricsTemplateIterator.this.lastTemplatePointer.write(0L, templateData, 0,
                        templateData.length);
                /* 108 */ NBBiometricsTemplateIterator.this.templateIdMap
                        .put(Integer.valueOf(NBBiometricsTemplateIterator.this.currentIndex), template.getKey());

                /* 110 */ ppTemplateId.setValue(new NBSizeType(NBBiometricsTemplateIterator.this.currentIndex));
                /* 111 */ ppTemplate.setValue(NBBiometricsTemplateIterator.this.lastTemplatePointer);
                /* 112 */ pstTemplateSize.setValue(new NBSizeType(templateData.length));

//                /* 114 */ NBBiometricsTemplateIterator.access$208(NBBiometricsTemplateIterator.this);
                /* 115 */ return 0;
            } catch (Throwable th) {
                /* 117 */ return NBErrors.setLast(th);
            }
        }
        /* 98 */ };

    /* 122 */ private final NBBiometricsTemplateIteratorHasNextTemplateProc hasNextCallback = new NBBiometricsTemplateIteratorHasNextTemplateProc() {
        public int invoke(NBSizeType pContext, IntByReference pbValue) {
            try {
                /* 126 */ pbValue.setValue(NBBiometricsTemplateIterator.this.templates.hasNext() ? 1 : 0);
                /* 127 */ return 0;
            } catch (Throwable th) {
                /* 129 */ return NBErrors.setLast(th);
            }
        }
        /* 122 */ };

    public NBBiometricsTemplateIterator(Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> templates) {
        /* 65 */ this.templates = templates;
    }

    public Object getTemplateId(NBSizeType pTemplateId) {
        /* 73 */ return this.templateIdMap.get(Integer.valueOf(pTemplateId.intValue()));
    }

    NBBiometricsTemplateIteratorData getInterface() {
        /* 139 */ NBBiometricsTemplateIteratorData data = new NBBiometricsTemplateIteratorData();
        /* 140 */ data.pContext = null;
        /* 141 */ data.pInitProc = this.initCallback;
        /* 142 */ data.pTerminateProc = this.terminateCallback;
        /* 143 */ data.pHasNextTemplateProc = this.hasNextCallback;
        /* 144 */ data.pNextTemplateProc = this.nextCallback;
        /* 145 */ data.pGetTemplatesProc = null;
        /* 146 */ return data;
    }

    static {
        /* 57 */ Native.register(NBBiometricsTemplateIterator.class, NBBiometricsLibrary.NATIVE_LIBRARY);
    }

    public static abstract interface NBBiometricsTemplateIteratorGetTemplatesProc extends NBCallback {
        public abstract int invoke(NBSizeType paramNBSizeType, PointerByReference paramPointerByReference1,
                PointerByReference paramPointerByReference2, PointerByReference paramPointerByReference3,
                IntByReference paramIntByReference);
    }

    public static abstract interface NBBiometricsTemplateIteratorHasNextTemplateProc extends NBCallback {
        public abstract int invoke(NBSizeType paramNBSizeType, IntByReference paramIntByReference);
    }

    public static abstract interface NBBiometricsTemplateIteratorNextTemplateProc extends NBCallback {
        public abstract int invoke(NBSizeType paramNBSizeType, NBSizeTypeByReference paramNBSizeTypeByReference1,
                PointerByReference paramPointerByReference, NBSizeTypeByReference paramNBSizeTypeByReference2);
    }

    public static abstract interface NBBiometricsTemplateIteratorTerminateProc extends NBCallback {
        public abstract int invoke(NBSizeType paramNBSizeType);
    }

    public static abstract interface NBBiometricsTemplateIteratorInitProc extends NBCallback {
        public abstract int invoke(NBSizeType paramNBSizeType);
    }
}
