package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceScanFormat {
    /* 12 */ FORMAT_12x17(0),

    /* 16 */ FORMAT_12x16(1),

    /* 20 */ FORMAT_PARTIAL(2),

    /* 24 */ FORMAT_12x12(3),

    /* 28 */ FORMAT_12x17_500(4),

    /* 32 */ FORMAT_12x16_500(5),

    /* 36 */ FORMAT_PARTIAL_500(6),

    /* 40 */ FORMAT_12x12_500(7),

    /* 44 */ FORMAT_QUARTER_PARTIAL(8),

    /* 48 */ FORMAT_QUARTER_PARTIAL_500(9),

    /* 52 */ FORMAT_15x20_500(10),

    /* 56 */ FORMAT_PARTIAL_NATIVE_500(11),

    /* 60 */ FORMAT_QUARTER_PARTIAL_NATIVE_500(12),

    /* 64 */ FORMAT_CUSTOM(13);

    private int value;

    private NBDeviceScanFormat(int value) {
        /* 77 */ this.value = value;
    }

    public static final NBDeviceScanFormat get(int value) {
        /* 85 */ for (NBDeviceScanFormat v : EnumSet.allOf(NBDeviceScanFormat.class)) {
            /* 86 */ if (value == v.getValue())
                /* 87 */ return v;
        }
        /* 89 */ throw new IllegalArgumentException("value is an unknown NBDeviceScanFormat value");
    }

    public final int getValue() {
        /* 97 */ return this.value;
    }
}
