package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceState {
    /* 12 */ NOT_CONNECTED(0),

    /* 16 */ NOT_AWAKE(1),

    /* 20 */ AWAKE(2);

    private int value;

    private NBDeviceState(int value) {
        /* 33 */ this.value = value;
    }

    public static final NBDeviceState get(int value) {
        /* 41 */ for (NBDeviceState v : EnumSet.allOf(NBDeviceState.class)) {
            /* 42 */ if (value == v.getValue())
                /* 43 */ return v;
        }
        /* 45 */ throw new IllegalArgumentException("value is an unknown NBDeviceState value");
    }

    public final int getValue() {
        /* 53 */ return this.value;
    }
}
