package com.nextbiometrics.devices;

import android.content.Context;
import com.nextbiometrics.devices.event.NBDevicesDeviceChangedEvent;
import com.nextbiometrics.devices.event.NBDevicesDeviceChangedListener;
import com.nextbiometrics.devices.jna.NBDeviceInfoAData;
import com.nextbiometrics.devices.jna.NBDeviceInfoAData.ByReference;
import com.nextbiometrics.devices.jna.NBDevicesDeviceEnumHelperData;
import com.nextbiometrics.devices.jna.NBUCommInterfaceStruct;
import com.nextbiometrics.system.NBCallback;
import com.nextbiometrics.system.NBCallbackParam;
import com.nextbiometrics.system.NBCallbacks;
import com.nextbiometrics.system.NBErrors;
import com.nextbiometrics.system.jna.NBSizeType;
import com.nextbiometrics.system.jna.NBUInt;
import com.nextbiometrics.system.jna.ptr.NBUIntByReference;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.LinkedList;
import java.util.List;

public final class NBDevices {
    /* 37 */ private static NBUCommInterface commInterface = null;

    /* 55 */ private static final NBDevicesDeviceChangedProcA deviceAddedCallback = new NBDevicesDeviceChangedProcA() {
        public int invoke(Pointer psDeviceInfo, NBSizeType pParam) {
            /* 58 */ return NBDevices.processCallback(psDeviceInfo, pParam, true);
        }
        /* 55 */ };

    /* 62 */ private static final NBDevicesDeviceChangedProcA deviceRemovedCallback = new NBDevicesDeviceChangedProcA() {
        public int invoke(Pointer psDeviceInfo, NBSizeType pParam) {
            /* 65 */ return NBDevices.processCallback(psDeviceInfo, pParam, false);
        }
        /* 62 */ };

    /* 108 */ private static List<Integer> callbackIdList = new LinkedList();
    /* 109 */ private static int initializationCount = 0;

    private static native int NBDevicesInitializeExA(NBDevicesDeviceEnumHelperData.ByReference paramByReference,
            NBDevicesDeviceChangedProcA paramNBDevicesDeviceChangedProcA1,
            NBDevicesDeviceChangedProcA paramNBDevicesDeviceChangedProcA2, NBSizeType paramNBSizeType, int paramInt);

    private static native int LlLibUsbSetCallbacks(NBUCommInterfaceStruct paramNBUCommInterfaceStruct);

    private static native int NBDevicesInitializeA(NBDevicesDeviceChangedProcA paramNBDevicesDeviceChangedProcA1,
            NBDevicesDeviceChangedProcA paramNBDevicesDeviceChangedProcA2, NBSizeType paramNBSizeType, int paramInt);

    private static native int NBDevicesIsInitialized(IntByReference paramIntByReference);

    private static native int NBDevicesTerminate();

    private static native int NBDevicesGetDevicesA(NBDeviceInfoAData.ByReference paramByReference, NBUInt paramNBUInt,
            NBUIntByReference paramNBUIntByReference);

    private static int processCallback(Pointer psDeviceInfo, NBSizeType pParam, boolean isAdded) {
        try {
            /* 75 */ NBDeviceInfoAData deviceInfo = new NBDeviceInfoAData(psDeviceInfo);
            /* 76 */ NBDevice device = NBDevice.connect(deviceInfo, 0L);
            /* 77 */ NBCallbackParam param = NBCallbacks.get(pParam.intValue());
            /* 78 */ NBDevicesDeviceChangedEvent event = new NBDevicesDeviceChangedEvent(device, device);
            /* 79 */ if (isAdded)
                /* 80 */ ((NBDevicesDeviceChangedListener) param.getListener()).added(event);
            else
                /* 82 */ ((NBDevicesDeviceChangedListener) param.getListener()).removed(event);
            /* 83 */ return 0;
        } catch (Throwable th) {
            /* 85 */ return NBErrors.setLast(th);
        }
    }

    public static final void initialize() {
        initialize((NBDevicesDeviceChangedListener) null);
    }

    public static final void initialize(NBDevicesDeviceChangedListener changedListener) {
        initialize(changedListener, 0L);
    }

    public static final void initialize(NBDevicesDeviceChangedListener changedListener, long flags) {
        boolean remove = false;
        int id = 0;
        if (changedListener != null) {
            id = NBCallbacks.add(null, changedListener);
            remove = true;
        }
        try {
            if (!isInitialized()) {
                NBErrors.requireNoErr(NBDevicesInitializeA(changedListener != null ? deviceAddedCallback : null,
                        changedListener != null ? deviceRemovedCallback : null, new NBSizeType(id), (int) flags));
                callbackIdList.add(Integer.valueOf(id));
                remove = false;
            }
            initializationCount += 1;
        } finally {
            if (remove)
                NBCallbacks.remove(id);
        }
    }

    public static final void initialize(Context context) {
        initialize(context, null, 0L);
    }

    public static final void initialize(Context context, NBDevicesDeviceChangedListener changedListener) {
        initialize(context, changedListener, 0L);
    }

    public static final void initialize(Context context, NBDevicesDeviceChangedListener changedListener, long flags) {
        boolean remove = false;
        int id = 0;
        if (changedListener != null) {
            id = NBCallbacks.add(null, changedListener);
            remove = true;
        }
        try {
            if (!isInitialized()) {
                commInterface = new UsbCommInterface(context);
                NBErrors.requireNoErr(LlLibUsbSetCallbacks(commInterface.getCommInterfaceStruct()));
                NBDevicesDeviceEnumHelperData.ByReference dataReference = new NBDevicesDeviceEnumHelperData.ByReference(
                        NBDevicesDeviceEnumHelper.getInterface(context));
                NBErrors.requireNoErr(NBDevicesInitializeExA(dataReference,
                        changedListener != null ? deviceAddedCallback : null,
                        changedListener != null ? deviceRemovedCallback : null, new NBSizeType(id), (int) flags));
                remove = false;
            }
            initializationCount += 1;
        } finally {
            if (remove)
                NBCallbacks.remove(id);
        }
    }

    public static final boolean isInitialized() {
        IntByReference value = new IntByReference();
        NBErrors.requireNoErr(NBDevicesIsInitialized(value));
        return value.getValue() != 0;
    }

    public static final void terminate() {
        if ((initializationCount > 0) && (--initializationCount == 0)) {
            NBErrors.requireNoErr(NBDevicesTerminate());
            NBErrors.requireNoErr(LlLibUsbSetCallbacks(null));
            for (Integer id : callbackIdList) {
                NBCallbacks.remove(id.intValue());
            }
            callbackIdList.clear();
        }
    }

    public static final NBDevice[] getDevices() {
        /* 261 */ NBUIntByReference uiDeviceCount = new NBUIntByReference();
        /* 262 */ NBErrors.requireNoErr(NBDevicesGetDevicesA(null, new NBUInt(0L), uiDeviceCount));
        /* 263 */ if (uiDeviceCount.getValue().intValue() == 0)
            return new NBDevice[0];
        /* 264 */ NBDeviceInfoAData.ByReference arsDeviceInfos = new NBDeviceInfoAData.ByReference();
        /* 265 */ NBDeviceInfoAData[] deviceInfos = (NBDeviceInfoAData[]) arsDeviceInfos
                .toArray(uiDeviceCount.getValue().intValue());
        /* 266 */ NBErrors
                .requireNoErr(NBDevicesGetDevicesA(arsDeviceInfos, new NBUInt(deviceInfos.length), uiDeviceCount));
        /* 267 */ int count = Math.min(deviceInfos.length, uiDeviceCount.getValue().intValue());
        /* 268 */ NBDevice[] devices = new NBDevice[count];
        /* 269 */ for (int i = 0; i < count; i++) {
            /* 270 */ devices[i] = NBDevice.connect(deviceInfos[i], 0L);
        }
        /* 272 */ return devices;
    }

    static {
        /* 94 */ Native.register(NBDevices.class, NBDevicesLibrary.NATIVE_LIBRARY);
    }

    private static abstract interface NBDevicesDeviceChangedProcA extends NBCallback {
        public abstract int invoke(Pointer paramPointer, NBSizeType paramNBSizeType);
    }
}
