package com.nextbiometrics.devices;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class UsbCommInterface extends NBUCommInterface {
    /* 33 */ public final String TAG = "NextBiometrics";
    /* 34 */ public final int DeviceInfoSize = 268;
    private static final String ACTION_USB_PERMISSION = "com.nextbiometrics.devices.USB_PERMISSION";
    private static final int LLLIBUSB_DEFAULT_VID = 10637;
    private UsbManager usbManager;
    /* 48 */ private HashMap<Long, ArrayList<UsbDevice>> enumList = new HashMap();
    /* 49 */ private PendingIntent permissionIntent = null;
    /* 50 */ private final BroadcastReceiver mUsbAttachedReceiver = new BroadcastReceiver() {
        public void onReceive(Context context, Intent intent) {
            /* 55 */ String action = intent.getAction();
            /* 56 */ if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action))
                /* 57 */ synchronized (this) {
                    /* 59 */ UsbDevice device = (UsbDevice) intent.getParcelableExtra("device");
                    /* 60 */ if ((device != null) && (device.getVendorId() == 10637)
                            && (!UsbCommInterface.this.usbManager.hasPermission(device)))
                        /* 61 */ UsbCommInterface.this.usbManager.requestPermission(device,
                                UsbCommInterface.this.permissionIntent);
                }
        }
        /* 50 */ };

    public UsbCommInterface(Context context) {
        this.usbManager = ((UsbManager) context.getApplicationContext().getSystemService("usb"));
        if (this.usbManager == null) {
            throw new NBUException(18);
        }
        this.permissionIntent = PendingIntent.getBroadcast(context, 0,
                new Intent("com.nextbiometrics.devices.USB_PERMISSION"), 0);

        IntentFilter attachedFilter = new IntentFilter("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        context.registerReceiver(this.mUsbAttachedReceiver, attachedFilter);

        Iterator it = this.usbManager.getDeviceList().values().iterator();
        while (it.hasNext()) {
            UsbDevice device = (UsbDevice) it.next();
            if ((device != null) && (device.getVendorId() == 10637) && (!this.usbManager.hasPermission(device)))
                this.usbManager.requestPermission(device, this.permissionIntent);
        }
    }

    protected Pointer openHandler(String devParams, Pointer enumHandle, int devNumber) {
        /* 114 */ if (this.usbManager == null) {
            /* 115 */ Log.i("NextBiometrics", String.format(
                    "openHandler(%s) -> NBUERROR_COMM_INIT_FAILED (USB not enabled)", new Object[] { devParams }));
            /* 116 */ throw new NBUException(1043);
        }

        /* 119 */ long id = Pointer.nativeValue(enumHandle);
        /* 120 */ UsbDevice dev = (UsbDevice) ((ArrayList) this.enumList.get(Long.valueOf(id))).get(devNumber);

        /* 122 */ Pointer ptr = null;
        /* 123 */ int in = -1;
        int out = -1;
        /* 124 */ if (this.usbManager.hasPermission(dev)) {
            /* 125 */ UsbDeviceConnection connection = this.usbManager.openDevice(dev);
            /* 126 */ UsbInterface iface = dev.getInterface(0);
            /* 127 */ for (int i = 0; i < iface.getEndpointCount(); i++) {
                /* 128 */ UsbEndpoint endpoint = iface.getEndpoint(i);
                /* 129 */ if ((endpoint.getDirection() == 128) && (in < 0)) {
                    /* 130 */ in = endpoint.getAddress();
                }
                /* 132 */ else if ((endpoint.getDirection() == 0) && (out < 0)) {
                    /* 133 */ out = endpoint.getAddress();
                }
            }
            /* 136 */ ptr = new Memory(268L);
            /* 137 */ ptr.clear(268L);
            /* 138 */ ptr.setInt(0L, connection.getFileDescriptor());
            /* 139 */ ptr.setInt(4L, in);
            /* 140 */ ptr.setInt(8L, out);
            /* 141 */ ptr.write(12L, dev.getDeviceName().getBytes(), 0, dev.getDeviceName().length());
        } else {
            /* 144 */ Log.i("NextBiometrics",
                    String.format("device (%d) does not have permission", new Object[] { devParams }));
        }

        /* 147 */ Log.i("NextBiometrics", String.format("openHandler(%s) -> OK", new Object[] { devParams }));

        /* 149 */ return ptr;
    }

    protected int enumDevicesInitHandler(String filter, PointerByReference enumHandle) {
        /* 154 */ ArrayList devices = new ArrayList();
        /* 155 */ Iterator it = this.usbManager.getDeviceList().values().iterator();

        /* 159 */ while (it.hasNext()) {
            /* 160 */ UsbDevice dev = (UsbDevice) it.next();
            /* 161 */ if ((dev.getVendorId() == 10637) && (this.usbManager.hasPermission(dev))) {
                /* 162 */ devices.add(dev);
            }
        }
        /* 165 */ for (long id = 1L; id < 100L; id += 1L) {
            /* 166 */ if (!this.enumList.containsKey(Long.valueOf(id))) {
                /* 167 */ this.enumList.put(Long.valueOf(id), devices);
                /* 168 */ enumHandle.setValue(new Pointer(id));
                /* 169 */ return 0;
            }
        }
        /* 172 */ throw new NBUException(128);
    }

    protected void enumDevicesDoneHandler(Pointer enumHandle) {
        /* 177 */ long id = Pointer.nativeValue(enumHandle);
        /* 178 */ if (this.enumList.containsKey(Long.valueOf(id)))
            /* 179 */ this.enumList.remove(Long.valueOf(id));
    }

    protected int enumGetDevNumberHandler(Pointer enumHandle) {
        /* 185 */ long id = Pointer.nativeValue(enumHandle);
        /* 186 */ return this.enumList.containsKey(Long.valueOf(id))
                ? ((ArrayList) this.enumList.get(Long.valueOf(id))).size()
                : 0;
    }

    protected int enumGetDevInfoHandler(Pointer enumHandle, int devNumber, int infoType, Pointer infoBuffer,
            IntByReference bufferSize) {
        /* 191 */ long id = Pointer.nativeValue(enumHandle);
        /* 192 */ if ((devNumber >= this.usbManager.getDeviceList().size())
                || (!this.enumList.containsKey(Long.valueOf(id)))) {
            /* 193 */ throw new NBUException(18);
        }
        /* 195 */ UsbDevice dev = (UsbDevice) ((ArrayList) this.enumList.get(Long.valueOf(id))).get(devNumber);
        /* 196 */ String name = null;
        /* 197 */ switch (infoType) {
            case 0:
                /* 199 */ if ((dev.getVendorId() == 10637) && (dev.getProductId() == 25888)) {
                    /* 200 */ name = "NB-65200-U";
                }
                /* 202 */ else if ((dev.getVendorId() == 10637) && (dev.getProductId() == 44289)) {
                    /* 203 */ name = "NB-65100-U";
                } else {
                    /* 206 */ name = "NB-Device";
                }
            case 1:
                /* 209 */ if (name == null) {
                    /* 210 */ name = dev.getDeviceName();
                }
                /* 212 */ int nameLen = name.length() + 3;
                /* 213 */ if (bufferSize.getValue() < name.length()) {
                    /* 214 */ bufferSize.setValue(nameLen);
                    /* 215 */ throw new NBUException(16);
                }

                /* 218 */ bufferSize.setValue(nameLen);
                /* 219 */ infoBuffer.setString(0L, name);

                /* 221 */ break;
            case 2:
                /* 223 */ if (bufferSize.getValue() < 4) {
                    /* 224 */ bufferSize.setValue(4);
                    /* 225 */ throw new NBUException(16);
                }

                /* 228 */ bufferSize.setValue(4);
                /* 229 */ int vid = dev.getVendorId();

                /* 231 */ infoBuffer.setInt(0L, vid);

                /* 233 */ break;
            case 3:
                /* 235 */ if (bufferSize.getValue() < 4) {
                    /* 236 */ bufferSize.setValue(4);
                    /* 237 */ throw new NBUException(16);
                }

                /* 240 */ bufferSize.setValue(4);
                /* 241 */ int pid = dev.getProductId();

                /* 243 */ infoBuffer.setInt(0L, pid);

                /* 245 */ break;
            case 4:
                /* 247 */ throw new NBUException(57);
        }
        /* 249 */ throw new NBUException(18);

//        /* 251 */ return 0;
    }
}
