package com.nextbiometrics.devices;

public final class NBDeviceCapabilities {
    public static final int NB_DEVICES_CAPABILITIES_VERSION = 1;
    public int version;
    public boolean supportsAntispoofing;
    public boolean supportsCustomScan;
    public boolean supportsUpscaling;
    public boolean requiresExternalCalibrationData;
    public byte supportedNativeImageTypes;
    public byte supportedUserImageTypes;
    public byte securityModel;
    public boolean supportsExtractOnDevice;
    public byte defaultUserImageType;

    public NBDeviceCapabilities(byte[] data) {
        /* 42 */ this.version = data[0];
        /* 43 */ if (this.version != 1) {
            /* 44 */ throw new IllegalArgumentException("NBDeviceCapabilities version mismatch");
        }
        /* 46 */ this.supportsAntispoofing = (data[4] != 0);
        /* 47 */ this.supportsCustomScan = (data[5] != 0);
        /* 48 */ this.supportsUpscaling = (data[6] != 0);
        /* 49 */ this.requiresExternalCalibrationData = (data[7] != 0);
        /* 50 */ this.supportedNativeImageTypes = data[8];
        /* 51 */ this.supportedUserImageTypes = data[9];
        /* 52 */ this.securityModel = data[10];
        /* 53 */ this.supportsExtractOnDevice = (data[11] != 0);
        /* 54 */ this.defaultUserImageType = data[12];
    }
}
