package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceScanStatus {
    /* 12 */ NONE(0),

    /* 16 */ OK(1),

    /* 20 */ CANCELED(2),

    /* 24 */ TIMEOUT(3),

    /* 28 */ NO_FINGER(4),

    /* 32 */ NOT_REMOVED(5),

    /* 36 */ BAD_QUALITY(6),

    /* 40 */ BAD_SIZE(7),

    /* 44 */ SPOOF(8),

    /* 46 */ EMPTY(4096), /* 47 */ DONE(4097), /* 48 */ LIFT_FINGER(4098),
    /* 49 */ WAIT_FOR_SENSOR_INITIALIZATION(4100), /* 50 */ PUT_FINGER_ON_SENSOR(4104),
    /* 51 */ KEEP_FINGER_ON_SENSOR(4112), /* 52 */ WAIT_FOR_DATA_PROCESSING(4128), /* 53 */ SPOOF_DETECTED(4160);

    private int value;

    private NBDeviceScanStatus(int value) {
        /* 66 */ this.value = value;
    }

    public static final NBDeviceScanStatus get(int value) {
        /* 74 */ for (NBDeviceScanStatus v : EnumSet.allOf(NBDeviceScanStatus.class)) {
            /* 75 */ if (value == v.getValue())
                /* 76 */ return v;
        }
        /* 78 */ throw new IllegalArgumentException("value is an unknown NBDeviceScanStatus value");
    }

    public final int getValue() {
        /* 86 */ return this.value;
    }
}
