package com.nextbiometrics.devices.jna;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
import java.util.Arrays;
import java.util.List;

public class NBDeviceScanFormatInfoData extends Structure {
    public int eScanFormat;
    public int eScanFormatType;
    public int uiLeft;
    public int uiBottom;
    public int uiWidth;
    public int uiHeight;
    public int uiHorizontalResolution;
    public int uiVerticalResolution;
    public byte uiFormatTag;

    public NBDeviceScanFormatInfoData() {
    }

    public NBDeviceScanFormatInfoData(Pointer p) {
        /* 46 */ super(p);
        /* 47 */ read();
    }

    protected List<String> getFieldOrder() {
        /* 52 */ return Arrays.asList(new String[] { "eScanFormat", "eScanFormatType", "uiLeft", "uiBottom", "uiWidth",
                "uiHeight", "uiHorizontalResolution", "uiVerticalResolution", "uiFormatTag" });
    }

    public static class ByReference extends NBDeviceScanFormatInfoData implements Structure.ByReference {
        public ByReference() {
            /* 12 */ this(null);
        }

        public ByReference(NBDeviceScanFormatInfoData value) {
            /* 17 */ if (value != null) {
                /* 18 */ this.eScanFormat = value.eScanFormat;
                /* 19 */ this.eScanFormatType = value.eScanFormatType;
                /* 20 */ this.uiLeft = value.uiLeft;
                /* 21 */ this.uiBottom = value.uiBottom;
                /* 22 */ this.uiWidth = value.uiWidth;
                /* 23 */ this.uiHeight = value.uiHeight;
                /* 24 */ this.uiHorizontalResolution = value.uiHorizontalResolution;
                /* 25 */ this.uiVerticalResolution = value.uiVerticalResolution;
                /* 26 */ this.uiFormatTag = value.uiFormatTag;
            }
        }
    }
}
