package com.nextbiometrics.devices.jna;

import com.nextbiometrics.system.jna.NBVersionData;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
import java.util.Arrays;
import java.util.List;

public class NBDeviceInfoAData extends Structure {
    public int uiDeviceIndex;
    public byte[] szId;
    public byte[] szManufacturer;
    public byte[] szModel;
    public byte[] szSerialNumber;
    public int eType;
    public NBVersionData sFirmwareVersion;

    public NBDeviceInfoAData() {
        /* 39 */ this.szId = new byte[256];
        /* 40 */ this.szManufacturer = new byte[256];
        /* 41 */ this.szModel = new byte[256];
        /* 42 */ this.szSerialNumber = new byte[256];
    }

    public NBDeviceInfoAData(Pointer p) {
        /* 46 */ super(p);
        /* 47 */ this.szId = new byte[256];
        /* 48 */ this.szManufacturer = new byte[256];
        /* 49 */ this.szModel = new byte[256];
        /* 50 */ this.szSerialNumber = new byte[256];
        /* 51 */ read();
    }

    protected List<String> getFieldOrder() {
        /* 56 */ return Arrays.asList(new String[] { "uiDeviceIndex", "szId", "szManufacturer", "szModel",
                "szSerialNumber", "eType", "sFirmwareVersion" });
    }

    public static class ByReference extends NBDeviceInfoAData implements Structure.ByReference {
        public ByReference() {
            /* 13 */ this(null);
        }

        public ByReference(NBDeviceInfoAData value) {
            /* 18 */ if (value != null) {
                /* 19 */ this.uiDeviceIndex = value.uiDeviceIndex;
                /* 20 */ this.szId = value.szId;
                /* 21 */ this.szManufacturer = value.szManufacturer;
                /* 22 */ this.szModel = value.szModel;
                /* 23 */ this.szSerialNumber = value.szSerialNumber;
                /* 24 */ this.eType = value.eType;
                /* 25 */ this.sFirmwareVersion = value.sFirmwareVersion;
            }
        }
    }
}
