package com.example.androidtest20200107.wifi;

import com.example.androidtest20200107.MyApp;

import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.widget.Toast;

public class WifiManage {
    private WifiReceiver wifiReceiver = new WifiReceiver();

    public void registerWifiBroadcast(WifiReceiver.WifiStateListener wifiStateListener) {
        // 刚注册广播时立即收到一条当前状态的广播
        IntentFilter filter = new IntentFilter();
        filter.addAction(WifiManager.WIFI_STATE_CHANGED_ACTION);
        filter.addAction("android.net.wifi.WIFI_AP_STATE_CHANGED");
        MyApp.getInstance().getApplicationContext().registerReceiver(wifiReceiver, filter);
        wifiReceiver.setWifiStateListener(wifiStateListener);
    }

    public void unregisterWifiBroadcast() {
        wifiReceiver.setWifiStateListener(null);
        MyApp.getInstance().getApplicationContext().unregisterReceiver(wifiReceiver);
    }

    public static void openOrCloseWifi() {
        if (WifiApUtils.isWifiApEnabled()) {
            WifiApUtils.closeWifiAP();
        }
        ;
        WifiUtils.setWifiEnabled(!WifiUtils.getWifiEnabled());
        Toast.makeText(MyApp.getInstance().getApplicationContext(),
                WifiUtils.getWifiEnabled() ? "正在关闭WiFi" : "正在打开WiFi", Toast.LENGTH_SHORT).show();
    }

}
