package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceLedState {
    /* 12 */ OFF(0),

    /* 16 */ FINGER_ON_REQUESTED(1),

    /* 20 */ IN_SCAN(4),

    /* 24 */ CUSTOM(6);

    private int value;

    private NBDeviceLedState(int value) {
        /* 37 */ this.value = value;
    }

    public static final NBDeviceLedState get(int value) {
        /* 45 */ for (NBDeviceLedState v : EnumSet.allOf(NBDeviceLedState.class)) {
            /* 46 */ if (value == v.getValue())
                /* 47 */ return v;
        }
        /* 49 */ throw new IllegalArgumentException("value is an unknown NBDeviceLedState value");
    }

    public final int getValue() {
        /* 57 */ return this.value;
    }
}
