package com.nextbiometrics.devices;

import com.nextbiometrics.devices.jna.NBDeviceScanFormatInfoData;

public final class NBDeviceScanFormatInfo {
    private NBDeviceScanFormat format;
    private NBDeviceScanFormatType formatType;
    private int left;
    private int bottom;
    private int width;
    private int height;
    private int horizontalResolution;
    private int verticalResolution;
    private byte formatTag;

    public NBDeviceScanFormatInfo(NBDeviceScanFormat format, NBDeviceScanFormatType formatType, int left, int bottom,
            int width, int height, int horizontalResolution, int verticalResolution, byte formatTag) {
        /* 30 */ this.format = format;
        /* 31 */ this.formatType = formatType;
        /* 32 */ this.left = left;
        /* 33 */ this.bottom = bottom;
        /* 34 */ this.width = width;
        /* 35 */ this.height = height;
        /* 36 */ this.horizontalResolution = horizontalResolution;
        /* 37 */ this.verticalResolution = verticalResolution;
        /* 38 */ this.formatTag = formatTag;
    }

    public NBDeviceScanFormatInfo(NBDeviceScanFormatInfoData data) {
        /* 42 */ this(NBDeviceScanFormat.get(data.eScanFormat), NBDeviceScanFormatType.get(data.eScanFormatType),
                data.uiLeft, data.uiBottom, data.uiWidth, data.uiHeight, data.uiHorizontalResolution,
                data.uiVerticalResolution, data.uiFormatTag);
    }

    public final NBDeviceScanFormat getFormat() {
        /* 55 */ return this.format;
    }

    public final NBDeviceScanFormatType getFormatType() {
        /* 64 */ return this.formatType;
    }

    public final int getWidth() {
        /* 73 */ return this.width;
    }

    public final int getHeight() {
        /* 82 */ return this.height;
    }

    public final int getLeft() {
        /* 91 */ return this.left;
    }

    public final int getBottom() {
        /* 100 */ return this.bottom;
    }

    public final int getHorizontalResolution() {
        /* 109 */ return this.horizontalResolution;
    }

    public final int getVerticalResolution() {
        /* 118 */ return this.verticalResolution;
    }

    public final int getFormatTag() {
        /* 127 */ return this.formatTag;
    }

    public String toString() {
        /* 136 */ return String.format("%s (%s): %dx%d %dx%d (%dx%d)",
                new Object[] { getFormat(), getFormatType(), Integer.valueOf(getLeft()), Integer.valueOf(getBottom()),
                        Integer.valueOf(getWidth()), Integer.valueOf(getHeight()),
                        Integer.valueOf(getHorizontalResolution()), Integer.valueOf(getVerticalResolution()) });
    }

    public boolean equals(Object o) {
        /* 141 */ if (o == this)
            return true;
        /* 142 */ if (!(o instanceof NBDeviceScanFormatInfo)) {
            /* 143 */ return false;
        }
        /* 145 */ NBDeviceScanFormatInfo scanFormatInfo = (NBDeviceScanFormatInfo) o;
        /* 146 */ return (scanFormatInfo.format.equals(this.format))
                && (scanFormatInfo.formatType.equals(this.formatType));
    }

    public int hashCode() {
        /* 151 */ return this.format.hashCode();
    }
}
