package android.scaner;

import android.os.RemoteException;

public class HsmScanerManager {
    private final IHsmScanerInterface mService;

    public HsmScanerManager(IHsmScanerInterface service) {
        mService = service;
    }

    public boolean openScaner() {
        try {
            return mService.openScaner();
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean closeScaner(boolean recall) {
        try {
            return mService.closeScaner(recall);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean startScanning(boolean decode) {
        try {
            return mService.startScanning(decode);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean stopScanning() {
        try {
            return mService.stopScanning();
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean isScanerOpened() {
        try {
            return mService.isScanerOpened();
        } catch (RemoteException e) {
        }
        return false;
    }

    public int getScanerState() {
        try {
            return mService.getScanerState();
        } catch (RemoteException e) {
        }
        return -1;
    }

    public boolean canRecall() {
        try {
            return mService.canRecall();
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean doGetScanningState() {
        try {
            return mService.doGetScanningState();
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean doEnableAllCode(boolean enable, boolean init) {
        try {
            return mService.doEnableAllCode(enable, init);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean doSetSymbology(int paramNum, int paramVal, boolean init) {
        try {
            return mService.doSetSymbology(paramNum, paramVal, init);
        } catch (RemoteException e) {
        }
        return false;
    }

    public int doGetParam(String paramNum) {
        try {
            return mService.doGetParam(paramNum);
        } catch (RemoteException e) {
        }
        return -1;
    }

    public boolean doSetParam(String paramNum, int paramVal, boolean init) {
        try {
            return mService.doSetParam(paramNum, paramVal, init);
        } catch (RemoteException e) {
        }
        return false;
    }

    public String doGetSymbologyConfig(int paramNum) {
        try {
            return mService.doGetSymbologyConfig(paramNum);
        } catch (RemoteException e) {
        }
        return "";
    }

    public boolean doSetSymbologyConfig(int paramNum, int flags, int mask, int maxLength, int minLength, boolean init) {
        try {
            return mService.doSetSymbologyConfig(paramNum, flags, mask, maxLength, minLength, init);
        } catch (RemoteException e) {
        }
        return false;
    }

    public String doGetOCRUserTemplate() {
        try {
            return mService.doGetOCRUserTemplate();
        } catch (RemoteException e) {
        }
        return "";
    }

    public boolean doSetOCRUserTemplate(String template, boolean init) {
        try {
            return mService.doSetOCRUserTemplate(template, init);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean doDefaultParams() {
        try {
            return mService.doDefaultParams();
        } catch (RemoteException e) {
        }
        return false;
    }

    public String doGetAPIRevision() {
        try {
            return mService.doGetAPIRevision();
        } catch (RemoteException e) {
        }
        return "";
    }

    public String doGetDecoderRevision() {
        try {
            return mService.doGetDecoderRevision();
        } catch (RemoteException e) {
        }
        return "";
    }

    public String doGetControlLogicRevision() {
        try {
            return mService.doGetControlLogicRevision();
        } catch (RemoteException e) {
        }
        return "";
    }

    public String doGetScanDriverRevision() {
        try {
            return mService.doGetScanDriverRevision();
        } catch (RemoteException e) {
        }
        return "";
    }

    public String doGetEngineID() {
        try {
            return mService.doGetEngineID();
        } catch (RemoteException e) {
        }
        return "";
    }

    public String doGetEngineSerialNumber() {
        try {
            return mService.doGetEngineSerialNumber();
        } catch (RemoteException e) {
        }
        return "";
    }
}
