package android.scaner;

import android.os.RemoteException;

public class SexxScanerManager {
    private final ISexxScanerInterface mService;

    public SexxScanerManager(ISexxScanerInterface service) {
        mService = service;
    }

    public boolean openScaner(boolean decode, boolean loop) {
        try {
            return mService.openScaner(decode, loop);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean closeScaner(boolean recall) {
        try {
            return mService.closeScaner(recall);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean doDecode(boolean decode) {
        try {
            return mService.doDecode(decode);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean doHandsFree(boolean decode) {
        try {
            return mService.doHandsFree(decode);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean isScanerOpened() {
        try {
            return mService.isScanerOpened();
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean canRecall() {
        try {
            return mService.canRecall();
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean doGetScanningState() {
        try {
            return mService.doGetScanningState();
        } catch (RemoteException e) {
        }
        return false;
    }

    public int doEnableAllCode(boolean enable, boolean init) {
        try {
            return mService.doEnableAllCode(enable, init);
        } catch (RemoteException e) {
        }
        return -1;
    }

    public int doSetParamStr(int num, String val, boolean init) {
        try {
            return mService.doSetParamStr(num, val, init);
        } catch (RemoteException e) {
        }
        return -1;
    }

    public int doSetParamNum(int num, int val, boolean init) {
        try {
            return mService.doSetParamNum(num, val, init);
        } catch (RemoteException e) {
        }
        return -1;
    }

    public int doGetParameterNum(int num) {
        try {
            return mService.doGetParameterNum(num);
        } catch (RemoteException e) {
        }
        return -1;
    }

    public String doGetParameterStr(int num) {
        try {
            return mService.doGetParameterStr(num);
        } catch (RemoteException e) {
        }
        return null;
    }

    public String doGetPropertyStr(int num) {
        try {
            return mService.doGetPropertyStr(num);
        } catch (RemoteException e) {
        }
        return null;
    }

    public int doDefaultParams() {
        try {
            return mService.doDefaultParams();
        } catch (RemoteException e) {
        }
        return -1;
    }
}
