package com.nextbiometrics.biometrics;

import com.nextbiometrics.biometrics.jna.NBBiometricsAlgorithmInfoData;
import com.nextbiometrics.system.NBVersion;
import com.nextbiometrics.system.jna.NBVersionData;

public final class NBBiometricsAlgorithmInfo {
    private int id;
    private NBVersion version;

    NBBiometricsAlgorithmInfo(int id, NBVersion version) {
        /* 22 */ this.id = id;
        /* 23 */ this.version = version;
    }

    NBBiometricsAlgorithmInfo(NBBiometricsAlgorithmInfoData data) {
        /* 27 */ this(data.uiId,
                new NBVersion(data.sVersion.major, data.sVersion.minor, data.sVersion.build, data.sVersion.revision));
    }

    public int getId() {
        /* 40 */ return this.id;
    }

    public final NBVersion getVersion() {
        /* 49 */ return this.version;
    }

    public String toString() {
        /* 58 */ return String.format("Vendor id: %d, Version: %s",
                new Object[] { Integer.valueOf(this.id), this.version });
    }
}
