package com.nextbiometrics.biometrics;

import java.util.EnumSet;

public enum NBBiometricsFingerPosition {
    /* 12 */ UNKNOWN(0),

    /* 16 */ RIGHT_THUMB(1),

    /* 20 */ RIGHT_INDEX(2),

    /* 24 */ RIGHT_MIDDLE(3),

    /* 28 */ RIGHT_RING(4),

    /* 32 */ RING_LITTLE(5),

    /* 36 */ LEFT_THUMB(6),

    /* 40 */ LEFT_INDEX(7),

    /* 44 */ LEFT_MIDDLE(8),

    /* 48 */ LEFT_RING(9),

    /* 52 */ LEFT_LITTLE(10);

    private int value;

    private NBBiometricsFingerPosition(int value) {
        /* 65 */ this.value = value;
    }

    public static final NBBiometricsFingerPosition get(int value) {
        /* 73 */ for (NBBiometricsFingerPosition v : EnumSet.allOf(NBBiometricsFingerPosition.class)) {
            /* 74 */ if (value == v.getValue())
                /* 75 */ return v;
        }
        /* 77 */ throw new IllegalArgumentException("value is an unknown NBBiometricsFingerPosition value");
    }

    public final int getValue() {
        /* 85 */ return this.value;
    }
}
