package com.nextbiometrics.biometrics;

import com.nextbiometrics.system.NBErrors;
import com.nextbiometrics.system.NBTypes;
import com.nextbiometrics.system.NBVersion;
import com.nextbiometrics.system.jna.NBVersionData;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;

public final class NBBiometricsLibrary {
    public static final NativeLibrary NATIVE_LIBRARY;

    private static native int NBBiometricsLibraryGetVersion(NBVersionData.ByReference paramByReference);

    public static final NBVersion getVersion() {
        NBVersionData.ByReference value = new NBVersionData.ByReference();
        NBErrors.requireNoErr(NBBiometricsLibraryGetVersion(value));
        return value.toVersion();
    }

    static {
        try {
            NATIVE_LIBRARY = NativeLibrary.getInstance("NBBiometrics", NBTypes.API_OPTIONS);
            Native.register(NBBiometricsLibrary.class, NATIVE_LIBRARY);
        } catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}
