package com.nextbiometrics.biometrics;

import java.util.EnumSet;

public enum NBBiometricsSecurityLevel {
    /* 12 */ LOWEST(0),

    /* 16 */ LOWER(1),

    /* 20 */ LOW(2),

    /* 24 */ BELOW_NORMAL(3),

    /* 28 */ NORMAL(4),

    /* 32 */ ABOVE_NORMAL(5),

    /* 36 */ HIGH(6),

    /* 40 */ HIGHER(7),

    /* 44 */ HIGHEST(8);

    private int value;

    private NBBiometricsSecurityLevel(int value) {
        /* 57 */ this.value = value;
    }

    public static final NBBiometricsSecurityLevel get(int value) {
        /* 65 */ for (NBBiometricsSecurityLevel v : EnumSet.allOf(NBBiometricsSecurityLevel.class)) {
            /* 66 */ if (value == v.getValue())
                /* 67 */ return v;
        }
        /* 69 */ throw new IllegalArgumentException("value is an unknown NBBiometricsSecurityLevel value");
    }

    public final int getValue() {
        /* 77 */ return this.value;
    }
}
