package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceFingerPosition {
    /* 12 */ Unknown(0),

    /* 16 */ RightThumb(1),

    /* 20 */ RightIndex(2),

    /* 24 */ RightMiddle(3),

    /* 28 */ RightRing(4),

    /* 32 */ RightLittle(5),

    /* 36 */ LeftThumb(6),

    /* 40 */ LeftIndex(7),

    /* 44 */ LeftMiddle(8),

    /* 48 */ LeftRing(9),

    /* 52 */ LeftLittle(10);

    private int value;

    private NBDeviceFingerPosition(int value) {
        /* 65 */ this.value = value;
    }

    public static final NBDeviceFingerPosition get(int value) {
        /* 73 */ for (NBDeviceFingerPosition v : EnumSet.allOf(NBDeviceFingerPosition.class)) {
            /* 74 */ if (value == v.getValue())
                /* 75 */ return v;
        }
        /* 77 */ throw new IllegalArgumentException("value is an unknown NBDeviceFingerPosition value");
    }

    public final int getValue() {
        /* 85 */ return this.value;
    }
}
