package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceImageType {
    /* 14 */ Default(0),

    /* 18 */ Raw(1),

    /* 22 */ CompensatedRaw(2),

    /* 26 */ Legacy(3),

    /* 30 */ Enhanced(4);

    private int value;

    private NBDeviceImageType(int value) {
        /* 43 */ this.value = value;
    }

    public static final NBDeviceImageType get(int value) {
        /* 51 */ for (NBDeviceImageType v : EnumSet.allOf(NBDeviceImageType.class)) {
            /* 52 */ if (value == v.getValue())
                /* 53 */ return v;
        }
        /* 55 */ throw new IllegalArgumentException("value is an unknown NBDeviceImageType value");
    }

    public final int getValue() {
        /* 63 */ return this.value;
    }
}
