package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceType {
    /* 12 */ UNKNOWN(0),

    /* 16 */ NB1010S(100),

    /* 20 */ NB1020S(101),

    /* 24 */ NB2020S(102),

    /* 28 */ NB2021S(103),

    /* 32 */ NB2022S(104),

    /* 36 */ NB2034S(105),

    /* 40 */ NB2023S(106),

    /* 44 */ NB2033S(107),

    /* 48 */ NB65210S(108),

    /* 52 */ NB1010U(200),

    /* 56 */ NB1020U(201),

    /* 60 */ NB2020U(202),

    /* 64 */ NB2024U(203),

    /* 68 */ NB3023U(204),

    /* 72 */ NB2023U(205),

    /* 76 */ NB65100U(300),

    /* 80 */ NB65200U(301),

    /* 84 */ NB65100UA(302);

    private int value;

    private NBDeviceType(int value) {
        /* 97 */ this.value = value;
    }

    public static final NBDeviceType get(int value) {
        /* 105 */ for (NBDeviceType v : EnumSet.allOf(NBDeviceType.class)) {
            /* 106 */ if (value == v.getValue())
                /* 107 */ return v;
        }
        /* 109 */ throw new IllegalArgumentException("value is an unknown NBDeviceType value");
    }

    public final int getValue() {
        /* 117 */ return this.value;
    }
}
