package com.nextbiometrics.system;

import java.io.Closeable;

public abstract class NBAbstractDisposable implements NBDisposable, Closeable {
    private boolean needsDispose;

    protected NBAbstractDisposable() {
        /* 10 */ this.needsDispose = true;
    }

    protected void check() {
        /* 14 */ if (isDisposed())
            /* 15 */ throw new IllegalStateException("Resources were already released");
    }

    protected abstract void dispose(boolean paramBoolean);

    public boolean isDisposed() {
        /* 22 */ return !this.needsDispose;
    }

    public void dispose() {
        /* 26 */ if (!isDisposed()) {
            /* 27 */ dispose(true);
            /* 28 */ this.needsDispose = false;
        }
    }

    public void close() {
        /* 33 */ dispose();
    }

    protected void finalize() throws Throwable {
        /* 37 */ if (!isDisposed()) {
            /* 38 */ dispose(false);
            /* 39 */ this.needsDispose = false;
        }
        /* 41 */ super.finalize();
    }
}
