package com.nextbiometrics.system.jna.ptr;

import com.nextbiometrics.system.jna.NBUInt;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;

public class NBUIntByReference extends ByReference {
    public NBUIntByReference() {
        /* 9 */ this(new NBUInt());
    }

    public NBUIntByReference(NBUInt value) {
        /* 13 */ super(4);
        /* 14 */ setValue(value);
    }

    public void setValue(NBUInt value) {
        /* 18 */ Pointer p = getPointer();
        /* 19 */ p.setInt(0L, value.intValue());
    }

    public NBUInt getValue() {
        /* 23 */ Pointer p = getPointer();
        /* 24 */ return new NBUInt(p.getInt(0L));
    }
}
