package com.example.androidtest20200107;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.scaner.CmxxScanerManager;
import android.scaner.HsmScanerManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity {

    private TextView mDataTv;
    private int mTypeScaner = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        mDataTv = (TextView) findViewById(R.id.data);

    }

    @Override
    protected void onResume() {
        super.onResume();

        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_SCANER_DECODE_DONE);
        filter.addAction("com.example.androidtest20200107.action_barcode_broadcast");
        this.registerReceiver(mReceiver, filter);
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            unregisterReceiver(mReceiver);
        } catch (Exception e) {
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_zebra) {
            mTypeScaner = 0;
            return true;
        } else if (id == R.id.action_honeywell) {
            mTypeScaner = 1;
            return true;
        } else if (id == R.id.action_newland) {
            mTypeScaner = 2;
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_ENTER) {
//			return false;
        }
//		Toast.makeText(this, "onKeyDown KeyCode: " + keyCode, Toast.LENGTH_SHORT).show();
        switch (keyCode) {
            case KeyEvent.KEYCODE_VOLUME_UP:
                sendBroadcast(new Intent("shmaker.android.intent.action.SCANER_DECODE"));
                return true;
            case KeyEvent.KEYCODE_VOLUME_DOWN:
                return true;
            default:
                break;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_ENTER) {
//			return false;
        }
//		Toast.makeText(this, "onKeyUp KeyCode: " + keyCode, Toast.LENGTH_SHORT).show();
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        Toast.makeText(this, "onKeyLongPress KeyCode: " + keyCode + ", Action: " + event.getAction(),
                Toast.LENGTH_SHORT).show();
        return super.onKeyLongPress(keyCode, event);
    }

    private boolean sound = false;
    private boolean viberate = true;
    private boolean loop = true;
    private boolean boot = true;

    public void btnClick(View view) {
        Log.i("gaochong", "id: " + view.getId());
        switch (view.getId()) {
            case R.id.open:
                Toast.makeText(this, "btnClick open", Toast.LENGTH_SHORT).show();
                if (mTypeScaner == 0) {
                    sendBroadcast(new Intent("shmaker.android.intent.action.SCANER_SERVICE_OPEN"));
                } else if (mTypeScaner == 1) {
                    HsmScanerManager hsmScanerManager = getHsmScanerManager();
                    if (hsmScanerManager != null) {
                        hsmScanerManager.openScaner();
                    }
                } else if (mTypeScaner == 2) {
                    CmxxScanerManager cmxxScanerManager = getCmxxScanerManager();
                    if (cmxxScanerManager != null) {
                        cmxxScanerManager.openScaner();
                    }
                }
                break;
            case R.id.close:
                if (mTypeScaner == 0) {
                    sendBroadcast(new Intent("shmaker.android.intent.action.SCANER_SERVICE_CLOSE"));
                } else if (mTypeScaner == 1) {
                    HsmScanerManager hsmScanerManager = getHsmScanerManager();
                    if (hsmScanerManager != null) {
                        hsmScanerManager.closeScaner(false);
                    }
                } else if (mTypeScaner == 2) {
                    CmxxScanerManager cmxxScanerManager = getCmxxScanerManager();
                    if (cmxxScanerManager != null) {
                        cmxxScanerManager.closeScaner(false);
                    }
                }
                break;
            case R.id.decode:
                if (mTypeScaner == 0) {
                    sendBroadcast(new Intent("shmaker.android.intent.action.SCANER_DECODE"));
                } else if (mTypeScaner == 1) {
                    HsmScanerManager hsmScanerManager = getHsmScanerManager();
                    if (hsmScanerManager != null) {
                        hsmScanerManager.startScanning(true);
                    }
                } else if (mTypeScaner == 2) {
                    CmxxScanerManager cmxxScanerManager = getCmxxScanerManager();
                    if (cmxxScanerManager != null) {
                        cmxxScanerManager.startScanning(true);
                    }
                }
                break;
            case R.id.stop:
                if (mTypeScaner == 0) {
                    sendBroadcast(new Intent("shmaker.android.intent.action.SCANER_STOP"));
                } else if (mTypeScaner == 1) {
                    HsmScanerManager hsmScanerManager = getHsmScanerManager();
                    if (hsmScanerManager != null) {
                        hsmScanerManager.startScanning(false);
                    }
                } else if (mTypeScaner == 2) {
                    CmxxScanerManager cmxxScanerManager = getCmxxScanerManager();
                    if (cmxxScanerManager != null) {
                        cmxxScanerManager.startScanning(false);
                    }
                }
                break;
            case R.id.sound:
                Intent intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("sound_play", sound);
                sendBroadcast(intent);
                sound = !sound;
                break;
            case R.id.viberate:
                intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("viberate", viberate);
                sendBroadcast(intent);
                viberate = !viberate;
                break;
            case R.id.loop:
                intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("scan_continue", loop);
                sendBroadcast(intent);
                loop = !loop;
                break;
            case R.id.interval:
                intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("interval", 10);
                sendBroadcast(intent);
                break;
            case R.id.prefix:
                intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("prefix", "prefix sound:" + sound);
                sendBroadcast(intent);
                break;
            case R.id.suffix:
                intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("suffix", "suffix viberate: " + viberate);
                sendBroadcast(intent);
                break;
            case R.id.boot:
                intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("boot_start", boot);
                sendBroadcast(intent);
                boot = !boot;
                break;
            case R.id.endchar:
                intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("endchar", "TAB");
                sendBroadcast(intent);
                break;
            case R.id.input:
                intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("barcode_send_mode", "BROADCAST");
                sendBroadcast(intent);
                break;
            case R.id.action:
                intent = new Intent("com.android.scanner.service_settings");
                intent.putExtra("action_barcode_broadcast", "com.example.androidtest20200107.action_barcode_broadcast");
                intent.putExtra("key_barcode_broadcast", "key_barcode_broadcast");
                sendBroadcast(intent);
                break;
            default:
                break;
        }
    }

    private void handlerScanDecodeSuccess(Intent intent) {
        String type = "";
        String data = "";
        String additional = "";
        String prefix = "";
        String suffix = "";
        String prefixAscii = "";
        String suffixAscii = "";
        String inputMode = "";
        boolean dataClear = false;

        if (intent.hasExtra(EXTRA_DECODE_TYPE)) {
            type = intent.getStringExtra(EXTRA_DECODE_TYPE);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA)) {
            data = intent.getStringExtra(EXTRA_DECODE_DATA);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_ADDITIONAL)) {
            additional = intent.getStringExtra(EXTRA_DECODE_DATA_ADDITIONAL);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_PREFIX)) {
            prefix = intent.getStringExtra(EXTRA_DECODE_DATA_PREFIX);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_SUFFIX)) {
            suffix = intent.getStringExtra(EXTRA_DECODE_DATA_SUFFIX);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_PREFIX_ASCII)) {
            prefixAscii = intent.getStringExtra(EXTRA_DECODE_DATA_PREFIX_ASCII);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_SUFFIX_ASCII)) {
            suffixAscii = intent.getStringExtra(EXTRA_DECODE_DATA_SUFFIX_ASCII);
        }
        if (intent.hasExtra(EXTRA_DECODE_INPUT_MODE)) {
            inputMode = intent.getStringExtra(EXTRA_DECODE_INPUT_MODE);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_CLEAR)) {
            dataClear = intent.getBooleanExtra(EXTRA_DECODE_DATA_CLEAR, false);
        }

        Log.i("gaochong",
                "handlerScanDecodeSuccess type: " + type + ", data: " + data + ", additional: " + additional
                        + ", prefix: " + prefix + ", suffix: " + suffix + ", prefixAscii: " + prefixAscii
                        + ", suffixAscii: " + suffixAscii + ", inputMode: " + inputMode + ", dataClear: " + dataClear);

        if (!TextUtils.isEmpty(type)) {
            data = "Type:" + type + "," + "Data:" + prefix + data + suffix;
        } else {
            data = prefix + data + suffix;
        }

        if ("4".equals(additional)) {
            data += " ";
        } else if ("3".equals(additional)) {
            data += "\t";
        } else if ("2".equals(additional)) {
            data += "\t";
        } else if ("1".equals(additional)) {
            data += "\n";
        }
        mDataTv.setText("[" + data + "]");
    }

    private void handlerScanDecodeSuccess2(Intent intent) {
        String type = "";
        String data = "";
        String additional = "";
        String prefix = "";
        String suffix = "";
        String prefixAscii = "";
        String suffixAscii = "";
        String inputMode = "";
        boolean dataClear = false;

        if (intent.hasExtra(EXTRA_DECODE_TYPE)) {
            type = intent.getStringExtra(EXTRA_DECODE_TYPE);
        }
        if (intent.hasExtra("key_barcode_broadcast")) {
            data = intent.getStringExtra("key_barcode_broadcast");
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_ADDITIONAL)) {
            additional = intent.getStringExtra(EXTRA_DECODE_DATA_ADDITIONAL);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_PREFIX)) {
            prefix = intent.getStringExtra(EXTRA_DECODE_DATA_PREFIX);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_SUFFIX)) {
            suffix = intent.getStringExtra(EXTRA_DECODE_DATA_SUFFIX);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_PREFIX_ASCII)) {
            prefixAscii = intent.getStringExtra(EXTRA_DECODE_DATA_PREFIX_ASCII);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_SUFFIX_ASCII)) {
            suffixAscii = intent.getStringExtra(EXTRA_DECODE_DATA_SUFFIX_ASCII);
        }
        if (intent.hasExtra(EXTRA_DECODE_INPUT_MODE)) {
            inputMode = intent.getStringExtra(EXTRA_DECODE_INPUT_MODE);
        }
        if (intent.hasExtra(EXTRA_DECODE_DATA_CLEAR)) {
            dataClear = intent.getBooleanExtra(EXTRA_DECODE_DATA_CLEAR, false);
        }

        Log.i("gaochong",
                "handlerScanDecodeSuccess2 type: " + type + ", data: " + data + ", additional: " + additional
                        + ", prefix: " + prefix + ", suffix: " + suffix + ", prefixAscii: " + prefixAscii
                        + ", suffixAscii: " + suffixAscii + ", inputMode: " + inputMode + ", dataClear: " + dataClear);

        if (!TextUtils.isEmpty(type)) {
            data = "Type:" + type + "," + "Data:" + prefix + data + suffix;
        } else {
            data = prefix + data + suffix;
        }

        if ("4".equals(additional)) {
            data += " ";
        } else if ("3".equals(additional)) {
            data += "\t";
        } else if ("2".equals(additional)) {
            data += "\t";
        } else if ("1".equals(additional)) {
            data += "\n";
        }
        mDataTv.setText("[" + data + "]");
    }

    private static final String ACTION_SCANER_DECODE_DONE = "shmaker.android.intent.action.SCANER_DECODE_DATA";

    private static final String EXTRA_DECODE_TYPE = "extra_decode_type";
    private static final String EXTRA_DECODE_DATA = "extra_decode_data";
    private static final String EXTRA_DECODE_FOCUS_INPUT = "extra_decode_focus_input";
    private static final String EXTRA_DECODE_INPUT_MODE = "extra_decode_input_mode";
    private static final String EXTRA_DECODE_DATA_ADDITIONAL = "extra_decode_data_additional";
    private static final String EXTRA_DECODE_DATA_PREFIX = "extra_decode_data_prefix";
    private static final String EXTRA_DECODE_DATA_SUFFIX = "extra_decode_data_suffix";
    private static final String EXTRA_DECODE_DATA_PREFIX_ASCII = "extra_decode_data_prefix_ascii";
    private static final String EXTRA_DECODE_DATA_SUFFIX_ASCII = "extra_decode_data_suffix_ascii";
    private static final String EXTRA_DECODE_DATA_CLEAR = "extra_decode_data_clear";

    private BroadcastReceiver mReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            Log.i("gaochong", "action: " + action);
            if (ACTION_SCANER_DECODE_DONE.equals(action)) {
                handlerScanDecodeSuccess(intent);
            } else if ("com.example.androidtest20200107.action_barcode_broadcast".equals(action)) {
                handlerScanDecodeSuccess2(intent);
            }
        }
    };

    private HsmScanerManager mHsmManager;

    private HsmScanerManager getHsmScanerManager() {
        if (mHsmManager == null) {
            mHsmManager = (HsmScanerManager) getSystemService("hsm_scaner");
        }
        return mHsmManager;
    }

    private CmxxScanerManager mCmxxScanerManager;

    private CmxxScanerManager getCmxxScanerManager() {
        if (mCmxxScanerManager == null) {
            mCmxxScanerManager = (CmxxScanerManager) getSystemService("cmxx_scaner");
        }
        return mCmxxScanerManager;
    }
}
