package com.example.androidtest20200107;

import java.util.StringTokenizer;

import android.Manifest;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
//import android.os.ServiceManager;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;

public class TestActivity extends Activity {

    private static final int MAC_ADDRESS_DIGITS = 6;
    private short[] mRandomMacAddr;
    private static final int PRODUCT_INFO_DIGITS = 1024;
    private short[] mProductInfo;

    private static final String MAC_ADDRESS_FILENAME = "/mnt/vendor/nvdata/APCFG/WIFI";
    private static final String IMEI_ADDRESS_FILENAME = "/data/nvram/md/NVRAM/NVD_IMEI/MP0B_001";
    private static final String PRODUCT_INFO_FILENAME = "/mnt/vendor/nvdata/APCFG/APRDEB/PRODUCT_INFO";

    private Toast mToast;
    View mView;

    private static final int MY_PERMISSIONS_REQUEST_SETTINGS = 1;

    private AlertDialog mDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mRandomMacAddr = new short[MAC_ADDRESS_DIGITS];
        mToast = Toast.makeText(this, null, Toast.LENGTH_SHORT);

        setContentView(R.layout.test_activity);

        sendBroadcast(new Intent("abc.abc.abc"));

//        requestPermission();
    }

    private void requestPermission() {
        if (ContextCompat.checkSelfPermission(this,
                Manifest.permission.WRITE_SETTINGS) != PackageManager.PERMISSION_GRANTED) {
            if (ActivityCompat.shouldShowRequestPermissionRationale(this, Manifest.permission.WRITE_SETTINGS)) {
                ActivityCompat.requestPermissions(this, new String[] { Manifest.permission.WRITE_SETTINGS },
                        MY_PERMISSIONS_REQUEST_SETTINGS);
            } else {
                ActivityCompat.requestPermissions(this, new String[] { Manifest.permission.WRITE_SETTINGS },
                        MY_PERMISSIONS_REQUEST_SETTINGS);
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String permissions[], int[] grantResults) {
        switch (requestCode) {
            case MY_PERMISSIONS_REQUEST_SETTINGS: {
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                } else {
                    showWaringDialog();
                }
                return;
            }
        }
    }

    private void showWaringDialog() {
        if (mDialog == null) {
            mDialog = new AlertDialog.Builder(this).setTitle("Warning!")
                    .setMessage("Please open the permissions of test from settings!")
                    .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            finish();
                        }
                    }).show();
        }
        mDialog.show();
    }

    @Override
    protected void onResume() {
        // TODO Auto-generated method stub
        super.onResume();
        registerReceiver(new BroadcastReceiver() {

            @Override
            public void onReceive(Context arg0, Intent arg1) {
                int i = Settings.Global.getInt(getContentResolver(), "long_press_power_shutdown", 0);
                Toast.makeText(TestActivity.this, "receiver shutdown: " + i, Toast.LENGTH_SHORT).show();
            }
        }, new IntentFilter("shmaker.android.intent.action.ACTION_SHUTDOWN"));
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_wifi) {
//            updateMacAddr();
            Settings.Global.putInt(getContentResolver(), "long_press_power_shutdown", 1);
            return true;
        } else if (id == R.id.action_imei1) {
//            undateImei();
            Settings.Global.putInt(getContentResolver(), "long_press_power_shutdown", 2);
            return true;
        } else if (id == R.id.action_imei2) {
//          undateImei();
            Settings.Global.putInt(getContentResolver(), "long_press_power_shutdown", 0);
            return true;
        } else if (id == R.id.action_boot) {
            int i = Settings.Global.getInt(getContentResolver(), "long_press_power_shutdown", 0);
            Toast.makeText(this, "shutdown: " + i, Toast.LENGTH_SHORT).show();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

//    private void updateMacAddr() {
//
//        try {
//            int i = 0;
//            IBinder binder = ServiceManager.getService("NvRAMAgent");
//            NvRAMAgent agent = NvRAMAgent.Stub.asInterface(binder);
//
//            // parse mac address firstly
//            StringTokenizer txtBuffer = new StringTokenizer("00:12:34:56:78:9b", ":");
//
//            while (txtBuffer.hasMoreTokens()) {
//                mRandomMacAddr[i] = (short) Integer.parseInt(txtBuffer.nextToken(), 16);
//                System.out.println(i + ":" + mRandomMacAddr[i]);
//                i++;
//            }
//
//            if (i != 6) {
//                mToast.setText("The format of mac address is not correct");
//                mToast.show();
//                return;
//            }
//
//            byte[] buff = null;
//
//            try {
//                buff = agent.readFileByName(MAC_ADDRESS_FILENAME);
//            } catch (Exception e) {
//                Log.i("gaochong", "updateMacAddr " + e);
//                e.printStackTrace();
//            }
//
//            String byffStr = bytesToHexString(buff);
//            Log.i("gaochong", "updateMacAddr byffStr: " + byffStr + ", size: " + buff.length);
//
//            /*
//             * for (i = 0; i < MAC_ADDRESS_DIGITS; i++) { buff[i + 4] = (byte)
//             * mRandomMacAddr[i]; }
//             * 
//             * int flag = 0;
//             * 
//             * try { flag = agent.writeFileByName(MAC_ADDRESS_FILENAME, buff); } catch
//             * (Exception e) { e.printStackTrace(); }
//             * 
//             * if (flag > 0) {
//             * mToast.setText("Update successfully.\r\nPlease reboot this device");
//             * mToast.show(); } else { mToast.setText("Update failed"); mToast.show(); }
//             */
//
//        } catch (Exception e) {
//            mToast.setText(e.getMessage() + ":" + e.getCause());
//            mToast.show();
//            e.printStackTrace();
//        }
//    }
//
//    private void undateImei() {
//        try {
//            IBinder binder = ServiceManager.getService("NvRAMAgent");
//            NvRAMAgent agent = NvRAMAgent.Stub.asInterface(binder);
//
//            byte[] buff = null;
//            for (int i = 0; i < MAC_ADDRESS_DIGITS; i++) {
//                buff[i + 4] = (byte) mRandomMacAddr[i];
//            }
//
//            int flag = 0;
//            try {
//                flag = agent.writeFileByName(IMEI_ADDRESS_FILENAME, buff);
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//
//            if (flag > 0) {
//                mToast.setText("Update successfully.\r\nPlease reboot this device");
//                mToast.show();
//            } else {
//                mToast.setText("Update failed");
//                mToast.show();
//            }
//        } catch (Exception e) {
//            mToast.setText(e.getMessage() + ":" + e.getCause());
//            mToast.show();
//            e.printStackTrace();
//        }
//    }
//
//    private void updateBootAnim() {
//
//        Log.i("gaochong", "updateBootAnim");
//        try {
//            IBinder binder = ServiceManager.getService("NvRAMAgent");
//            NvRAMAgent agent = NvRAMAgent.Stub.asInterface(binder);
//
//            byte[] buff = null;
//
//            try {
//                buff = agent.readFileByName(PRODUCT_INFO_FILENAME);
//            } catch (Exception e) {
//                Log.e("gaochong", "e: " + e);
//                e.printStackTrace();
//            }
//
//            String byffStr = bytesToHexString(buff);
//            Log.i("gaochong", "updateBootAnim byffStr: " + byffStr + ", size: " + buff.length);
//            /*
//             * int flag = 0;
//             * 
//             * try { flag = agent.writeFileByName(MAC_ADDRESS_FILENAME, buff); } catch
//             * (Exception e) { e.printStackTrace(); }
//             * 
//             * if (flag > 0) {
//             * mToast.setText("Update successfully.\r\nPlease reboot this device");
//             * mToast.show(); } else { mToast.setText("Update failed"); mToast.show(); }
//             */
//
//        } catch (Exception e) {
//            mToast.setText(e.getMessage() + ":" + e.getCause());
//            mToast.show();
//            e.printStackTrace();
//            Log.e("gaochong", "e: " + e);
//        }
//    }

    public float getFocalLength() {
        // return Float.parseFloat(get(KEY_FOCAL_LENGTH));
        return 2.94f;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src != null) {
            for (int i = 0; i < src.length; i++) {
                int v = src[i] & 0xFF;
                String hv = Integer.toHexString(v);
                if (hv.length() < 2) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
            }
        } else {
            stringBuilder.append("null");
        }
        String result = stringBuilder.toString();
        return result;
    }
}