package com.nextbiometrics.biometrics;

import com.nextbiometrics.system.NBErrors;
import com.nextbiometrics.system.jna.NBSizeType;
import com.nextbiometrics.system.jna.ptr.NBSizeTypeByReference;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;

public final class NBBiometricsTemplate {
    private byte[] data;

    private static native int NBBiometricsTemplateGetPosition(byte[] paramArrayOfByte, NBSizeType paramNBSizeType,
            IntByReference paramIntByReference);

    private static native int NBBiometricsTemplateGetType(byte[] paramArrayOfByte, NBSizeType paramNBSizeType,
            IntByReference paramIntByReference);

    private static native int NBBiometricsTemplateGetSize(byte[] paramArrayOfByte, NBSizeType paramNBSizeType,
            NBSizeTypeByReference paramNBSizeTypeByReference);

    private static native int NBBiometricsTemplateGetQuality(byte[] paramArrayOfByte, NBSizeType paramNBSizeType,
            IntByReference paramIntByReference);

    NBBiometricsTemplate(byte[] data, NBSizeType dataSize, NBSizeType actualSize) {
        /* 43 */ this.data = Arrays.copyOf(data, actualSize.intValue());
    }

    public final NBBiometricsFingerPosition getPosition() {
        /* 56 */ IntByReference value = new IntByReference();
        /* 57 */ NBErrors
                .requireNoErr(NBBiometricsTemplateGetPosition(this.data, new NBSizeType(this.data.length), value));
        /* 58 */ return NBBiometricsFingerPosition.get(value.getValue());
    }

    public final NBBiometricsTemplateType getType() {
        /* 67 */ IntByReference value = new IntByReference();
        /* 68 */ NBErrors.requireNoErr(NBBiometricsTemplateGetType(this.data, new NBSizeType(this.data.length), value));
        /* 69 */ return NBBiometricsTemplateType.get(value.getValue());
    }

    public final int getQuality() {
        /* 78 */ IntByReference value = new IntByReference();
        /* 79 */ NBErrors
                .requireNoErr(NBBiometricsTemplateGetQuality(this.data, new NBSizeType(this.data.length), value));
        /* 80 */ return value.getValue();
    }

    public final byte[] getData() {
        /* 89 */ return this.data;
    }

    public String toString() {
        /* 99 */ return String.format("Template type: %s, Position: %s, Quality: %s",
                new Object[] { getType(), getPosition(), Integer.valueOf(getQuality()) });
    }

    static {
        /* 35 */ Native.register(NBBiometricsTemplate.class, NBBiometricsLibrary.NATIVE_LIBRARY);
    }
}
