package com.nextbiometrics.biometrics;

import com.nextbiometrics.biometrics.jna.NBBiometricsVerifyResultDetailsData;

public final class NBBiometricsVerifyResult {
    private NBBiometricsStatus status;
    private int score;

    NBBiometricsVerifyResult(NBBiometricsStatus status, int score) {
        /* 21 */ this.status = status;
        /* 22 */ this.score = score;
    }

    NBBiometricsVerifyResult(NBBiometricsStatus status, NBBiometricsVerifyResultDetailsData data) {
        /* 26 */ this(status, data.iScore);
    }

    public final NBBiometricsStatus getStatus() {
        /* 38 */ return this.status;
    }

    public final int getScore() {
        /* 45 */ return this.score;
    }

    public String toString() {
        /* 54 */ return String.format("Status: %s, Score: %d",
                new Object[] { this.status, Integer.valueOf(this.score) });
    }
}
