package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceStopMode {
    /* 12 */ CONTINUOUS_FINGER_DETECTION(0),

    /* 16 */ HARD_STOP(1),

    /* 20 */ COUNTED_FINGER_DETECTION(2);

    private int value;

    private NBDeviceStopMode(int value) {
        /* 33 */ this.value = value;
    }

    public static final NBDeviceStopMode get(int value) {
        /* 41 */ for (NBDeviceStopMode v : EnumSet.allOf(NBDeviceStopMode.class)) {
            /* 42 */ if (value == v.getValue())
                /* 43 */ return v;
        }
        /* 45 */ throw new IllegalArgumentException("value is an unknown NBDeviceStopMode value");
    }

    public final int getValue() {
        /* 53 */ return this.value;
    }
}
