package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceEncodeFormat {
    /* 12 */ Iso010(0),

    /* 16 */ Iso010Jpeg2000(1),

    /* 24 */ Iso010Jpeg2000Aadhaar(2),

    /* 28 */ Iso020(3),

    /* 32 */ Iso020Jpeg2000(4),

    /* 36 */ Iso010WSQ(5),

    /* 40 */ Iso020WSQ(6),

    /* 44 */ WSQ(7);

    private int value;

    private NBDeviceEncodeFormat(int value) {
        /* 57 */ this.value = value;
    }

    public static final NBDeviceEncodeFormat get(int value) {
        /* 65 */ for (NBDeviceEncodeFormat v : EnumSet.allOf(NBDeviceEncodeFormat.class)) {
            /* 66 */ if (value == v.getValue())
                /* 67 */ return v;
        }
        /* 69 */ throw new IllegalArgumentException("value is an unknown NBDeviceEncodeFormat value");
    }

    public final int getValue() {
        /* 77 */ return this.value;
    }
}
