package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceSecurityModel {
    /* 12 */ ModelNone(0),

    /* 16 */ Model65100(1),

    /* 20 */ Model65200CakOnly(2),

    /* 24 */ Model65200CakCdk(3);

    private int value;

    private NBDeviceSecurityModel(int value) {
        /* 37 */ this.value = value;
    }

    public static final NBDeviceSecurityModel get(int value) {
        /* 45 */ for (NBDeviceSecurityModel v : EnumSet.allOf(NBDeviceSecurityModel.class)) {
            /* 46 */ if (value == v.getValue())
                /* 47 */ return v;
        }
        /* 49 */ throw new IllegalArgumentException("value is an unknown NBDeviceSecurityModel value");
    }

    public final int getValue() {
        /* 57 */ return this.value;
    }
}
