package com.nextbiometrics.devices;

import com.nextbiometrics.devices.jna.NBDevicesDeviceEnumHelperData;
import com.nextbiometrics.system.NBCallback;
import com.nextbiometrics.system.NBErrors;
import com.nextbiometrics.system.jna.NBSizeType;
import com.nextbiometrics.system.jna.NBUInt;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public final class NBDevicesDeviceEnumHelper {
    private static final String TAG = "NBDevicesDeviceEnumHelper";
    /* 78 */ private static Map<Integer, Object> contextParametersMap = Collections.synchronizedMap(new HashMap());

    /* 80 */ private static final NBDevicesEnumInitProc initCallback = new NBDevicesEnumInitProc() {
        public int invoke(NBSizeType pContext,
                NBDevicesDeviceEnumHelper.NBDevicesReenumerateDevicesProc pReenumerateDevicesProc, NBSizeType pParam) {
            try {
                /* 84 */ Object context = NBDevicesDeviceEnumHelper.getContextParameter(pContext.intValue());
                /* 85 */ if ((context != null) && ((context instanceof NBDevicesDeviceEnumHelper.IDeviceEnumHelper))) {
                    /* 86 */ ((NBDevicesDeviceEnumHelper.IDeviceEnumHelper) context).initialize(pReenumerateDevicesProc,
                            pParam);
                }
                /* 88 */ return 0;
            } catch (Throwable th) {
                /* 90 */ return NBErrors.setLast(th);
            }
        }
        /* 80 */ };

    /* 95 */ private static final NBDevicesEnumTerminateProc terminateCallback = new NBDevicesEnumTerminateProc() {
        public int invoke(NBSizeType pContext) {
            try {
                /* 99 */ Object context = NBDevicesDeviceEnumHelper.getContextParameter(pContext.intValue());
                /* 100 */ if ((context != null) && ((context instanceof NBDevicesDeviceEnumHelper.IDeviceEnumHelper))) {
                    /* 101 */ ((NBDevicesDeviceEnumHelper.IDeviceEnumHelper) context).terminate();
                    /* 102 */ NBDevicesDeviceEnumHelper.removeContextParameter(pContext.intValue());
                }
                /* 104 */ return 0;
            } catch (Throwable th) {
                /* 106 */ return NBErrors.setLast(th);
            }
        }
        /* 95 */ };

    /* 111 */ private static final NBDevicesEnumUpdateProc updateCallback = new NBDevicesEnumUpdateProc() {
        public int invoke(NBSizeType pContext, Pointer arhDevices, NBUInt uiDevicesLength,
                NBDevicesDeviceEnumHelper.NBDevicesNewDeviceProc pNewDeviceProc,
                NBDevicesDeviceEnumHelper.NBDevicesFoundDeviceProc pFoundDeviceProc, NBSizeType pParam) {
            try {
                /* 115 */ Object context = NBDevicesDeviceEnumHelper.getContextParameter(pContext.intValue());
                /* 116 */ if ((context != null) && ((context instanceof NBDevicesDeviceEnumHelper.IDeviceEnumHelper))) {
                    /* 117 */ NBDevice[] devices = new NBDevice[uiDevicesLength.intValue()];
                    /* 118 */ if (devices.length > 0) {
                        /* 119 */ Pointer[] devicesPtr = arhDevices.getPointerArray(0L, uiDevicesLength.intValue());
                        /* 120 */ for (int i = 0; i < devices.length; i++) {
                            /* 121 */ devices[i] = new NBDevice(devicesPtr[i], false);
                        }
                    }
                    /* 124 */ ((NBDevicesDeviceEnumHelper.IDeviceEnumHelper) context).update(devices, pNewDeviceProc,
                            pFoundDeviceProc, pParam);
                }
                /* 126 */ return 0;
            } catch (Throwable th) {
                /* 128 */ return NBErrors.setLast(th);
            }
        }
        /* 111 */ };

    public static final NBDevicesDeviceEnumHelperData getInterface(Object context) {
        /* 138 */ NBDevicesDeviceEnumHelperData data = new NBDevicesDeviceEnumHelperData();
        /* 139 */ data.pContext = new NBSizeType(addContextParameter(new AndroidDeviceEnumHelper(context)));
        /* 140 */ data.pInitProc = initCallback;
        /* 141 */ data.pTerminateProc = terminateCallback;
        /* 142 */ data.pUpdateProc = updateCallback;
        /* 143 */ return data;
    }

    private static synchronized int addContextParameter(Object param) {
        /* 151 */ Random r = new Random();
        int id;
        do
            /* 153 */ id = r.nextInt();
        /* 154 */ while (contextParametersMap.containsKey(Integer.valueOf(id)));
        /* 155 */ contextParametersMap.put(Integer.valueOf(id), param);
        /* 156 */ return id;
    }

    private static synchronized Object getContextParameter(int id) {
        /* 161 */ Object param = null;
        /* 162 */ if (contextParametersMap.containsKey(Integer.valueOf(id))) {
            /* 163 */ param = contextParametersMap.get(Integer.valueOf(id));
        }
        /* 165 */ return param;
    }

    private static synchronized void removeContextParameter(int id) {
        /* 169 */ if (contextParametersMap.containsKey(Integer.valueOf(id)))
            /* 170 */ contextParametersMap.remove(Integer.valueOf(id));
    }

    static {
        /* 64 */ Native.register(NBDevicesDeviceEnumHelper.class, NBDevicesLibrary.NATIVE_LIBRARY);
    }

    static abstract interface IDeviceEnumHelper {
        public abstract void initialize(
                NBDevicesDeviceEnumHelper.NBDevicesReenumerateDevicesProc paramNBDevicesReenumerateDevicesProc,
                NBSizeType paramNBSizeType);

        public abstract void update(NBDevice[] paramArrayOfNBDevice,
                NBDevicesDeviceEnumHelper.NBDevicesNewDeviceProc paramNBDevicesNewDeviceProc,
                NBDevicesDeviceEnumHelper.NBDevicesFoundDeviceProc paramNBDevicesFoundDeviceProc,
                NBSizeType paramNBSizeType);

        public abstract void terminate();
    }

    public static abstract interface NBDevicesEnumTerminateProc extends NBCallback {
        public abstract int invoke(NBSizeType paramNBSizeType);
    }

    public static abstract interface NBDevicesEnumUpdateProc extends NBCallback {
        public abstract int invoke(NBSizeType paramNBSizeType1, Pointer paramPointer, NBUInt paramNBUInt,
                NBDevicesDeviceEnumHelper.NBDevicesNewDeviceProc paramNBDevicesNewDeviceProc,
                NBDevicesDeviceEnumHelper.NBDevicesFoundDeviceProc paramNBDevicesFoundDeviceProc,
                NBSizeType paramNBSizeType2);
    }

    public static abstract interface NBDevicesEnumInitProc extends NBCallback {
        public abstract int invoke(NBSizeType paramNBSizeType1,
                NBDevicesDeviceEnumHelper.NBDevicesReenumerateDevicesProc paramNBDevicesReenumerateDevicesProc,
                NBSizeType paramNBSizeType2);
    }

    public static abstract interface NBDevicesFoundDeviceProc extends NBCallback {
        public abstract int invoke(Pointer paramPointer, NBSizeType paramNBSizeType);
    }

    public static abstract interface NBDevicesNewDeviceProc extends NBCallback {
        public abstract int invoke(Pointer paramPointer, NBSizeType paramNBSizeType);
    }

    public static abstract interface NBDevicesReenumerateDevicesProc extends NBCallback {
        public abstract int invoke(NBSizeType paramNBSizeType);
    }
}
