package com.nextbiometrics.devices;

import com.nextbiometrics.system.NBErrors;
import com.nextbiometrics.system.NBTypes;
import com.nextbiometrics.system.NBVersion;
import com.nextbiometrics.system.jna.NBVersionData;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;

public final class NBDevicesLibrary {
    public static final NativeLibrary NATIVE_LIBRARY;

    private static native int NBDevicesLibraryGetVersion(NBVersionData.ByReference paramByReference);

    public static final NBVersion getVersion() {
        NBVersionData.ByReference value = new NBVersionData.ByReference();
        NBErrors.requireNoErr(NBDevicesLibraryGetVersion(value));
        return value.toVersion();
    }

    static {
        try {
            NATIVE_LIBRARY = NativeLibrary.getInstance("NBBiometrics", NBTypes.API_OPTIONS);
            Native.register(NBDevicesLibrary.class, NATIVE_LIBRARY);
        } catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}
