package com.nextbiometrics.devices;

import com.nextbiometrics.devices.jna.NBUCommInterfaceStruct;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

public class NBUCommInterface {
    public static final int LL_INTERFACE_VERSION = 1;
    /* 28 */ private NBUCommInterfaceStruct commInterfaceStruct = null;

    public NBUCommInterface() {
        /* 36 */ this.commInterfaceStruct = new NBUCommInterfaceStruct(new InitializeHandler() {
            public int invoke() {
                /* 41 */ int error = 0;
                try {
                    /* 43 */ NBUCommInterface.this.initializeHandler();
                } catch (NBUException ex) {
                    /* 45 */ error = ex.getCode();
                    /* 46 */ }
                return error;
            }
        }, new TerminateHandler() {
            public int invoke() {
                /* 53 */ int error = 0;
                try {
                    /* 55 */ NBUCommInterface.this.terminateHandler();
                } catch (NBUException ex) {
                    /* 57 */ error = ex.getCode();
                    /* 58 */ }
                return error;
            }
        }, new OpenHandler() {
            public Pointer invoke(String devParams, Pointer enumHandle, int devNumber) {
                /* 65 */ int error = 0;
                /* 66 */ Pointer res = null;
                try {
                    /* 68 */ res = NBUCommInterface.this.openHandler(devParams, enumHandle, devNumber);
                } catch (NBUException ex) {
                    /* 70 */ error = ex.getCode();
                    /* 71 */ }
                return error == 0 ? res : null;
            }
        }, new CloseHandler() {
            public void invoke(Pointer handle) {
                /* 78 */ int error = 0;
                try {
                    /* 80 */ NBUCommInterface.this.closeHandler();
                } catch (NBUException ex) {
                    /* 82 */ error = ex.getCode();
                }
            }
        }, new ReopenHandler() {
            public int invoke(Pointer handle) {
                /* 89 */ int error = 0;
                try {
                    /* 91 */ NBUCommInterface.this.reopenHandler();
                } catch (NBUException ex) {
                    /* 93 */ error = ex.getCode();
                    /* 94 */ }
                return error;
            }
        }, new SetTimeoutHandler() {
            public int invoke(Pointer handle, int timeoutMs) {
                /* 101 */ int error = 0;
                try {
                    /* 103 */ NBUCommInterface.this.setTimeoutHandler(timeoutMs);
                } catch (NBUException ex) {
                    /* 105 */ error = ex.getCode();
                    /* 106 */ }
                return error;
            }
        }, new WaitForPacketStartHandler() {
            public int invoke(Pointer handle) {
                /* 113 */ int error = 0;
                try {
                    /* 115 */ NBUCommInterface.this.waitForPacketStartHandler();
                } catch (NBUException ex) {
                    /* 117 */ error = ex.getCode();
                    /* 118 */ }
                return error;
            }
        }, new ReceiveByteHandler() {
            public int invoke(Pointer handle, ByteByReference value) {
                /* 125 */ int error = 0;
                try {
                    /* 127 */ byte b = NBUCommInterface.this.receiveByteHandler();
                    /* 128 */ value.setValue(b);
                } catch (NBUException ex) {
                    /* 130 */ error = ex.getCode();
                    /* 131 */ }
                return error;
            }
        }, new SetRemainingSizeHandler() {
            public void invoke(Pointer handle, int receiveDataSize) {
                /* 138 */ int error = 0;
                try {
                    /* 140 */ NBUCommInterface.this.setRemainingSizeHandler(receiveDataSize);
                } catch (NBUException ex) {
                    /* 142 */ error = ex.getCode();
                }
            }
        }, new StartPacketSendHandler() {
            public int invoke(Pointer handle, int packetSize) {
                /* 149 */ int error = 0;
                try {
                    /* 151 */ NBUCommInterface.this.startPacketSendHandler(packetSize);
                } catch (NBUException ex) {
                    /* 153 */ error = ex.getCode();
                    /* 154 */ }
                return error;
            }
        }, new SendByteHandler() {
            public int invoke(Pointer handle, byte value, boolean lastByte) {
                /* 161 */ int error = 0;
                try {
                    /* 163 */ NBUCommInterface.this.sendByteHandler(value, lastByte);
                } catch (NBUException ex) {
                    /* 165 */ error = ex.getCode();
                    /* 166 */ }
                return error;
            }
        }, null, null, null, new EnumDevicesInitHandler() {
            public int invoke(String filter, PointerByReference enumHandle) {
                /* 182 */ int error = 0;
                try {
                    /* 184 */ NBUCommInterface.this.enumDevicesInitHandler(filter, enumHandle);
                } catch (NBUException ex) {
                    /* 186 */ error = ex.getCode();
                    /* 187 */ }
                return error;
            }
        }, new EnumDevicesDoneHandler() {
            public void invoke(Pointer enumHandle) {
                /* 194 */ NBUCommInterface.this.enumDevicesDoneHandler(enumHandle);
            }
        }, new EnumGetDevNumberHandler() {
            public int invoke(Pointer enumHandle) {
                /* 201 */ return NBUCommInterface.this.enumGetDevNumberHandler(enumHandle);
            }
        }, new EnumGetDevInfoHandler() {
            public int invoke(Pointer enumHandle, int devNumber, int infoType, Pointer infoBuffer,
                    IntByReference bufferSize) {
                /* 208 */ int error = 0;
                try {
                    /* 210 */ NBUCommInterface.this.enumGetDevInfoHandler(enumHandle, devNumber, infoType, infoBuffer,
                            bufferSize);
                } catch (NBUException ex) {
                    /* 212 */ error = ex.getCode();
                    /* 213 */ }
                return error;
            }
        });
    }

    public NBUCommInterfaceStruct getCommInterfaceStruct() {
        /* 226 */ return this.commInterfaceStruct;
    }

    protected void initializeHandler() {
        /* 243 */ throw new NBUException(57);
    }

    protected void terminateHandler() {
        /* 255 */ throw new NBUException(57);
    }

    protected Pointer openHandler(String devParams, Pointer enumHandle, int devNumber) {
        /* 273 */ throw new NBUException(57);
    }

    protected void closeHandler() {
    }

    protected void reopenHandler() {
        /* 295 */ throw new NBUException(57);
    }

    protected void setTimeoutHandler(int timeoutMs) {
        /* 309 */ throw new NBUException(57);
    }

    protected void waitForPacketStartHandler() {
        /* 327 */ throw new NBUException(57);
    }

    protected byte receiveByteHandler() {
        /* 343 */ throw new NBUException(57);
    }

    protected void setRemainingSizeHandler(int receiveDataSize) {
        /* 366 */ throw new NBUException(57);
    }

    protected void startPacketSendHandler(int packetSize) {
        /* 387 */ throw new NBUException(57);
    }

    protected void sendByteHandler(byte value, boolean lastByte) {
        /* 408 */ throw new NBUException(57);
    }

    protected int enumDevicesInitHandler(String filter, PointerByReference enumHandle) {
        /* 413 */ throw new NBUException(57);
    }

    protected void enumDevicesDoneHandler(Pointer enumHandle) {
        /* 417 */ throw new NBUException(57);
    }

    protected int enumGetDevNumberHandler(Pointer enumHandle) {
        /* 421 */ throw new NBUException(57);
    }

    protected int enumGetDevInfoHandler(Pointer enumHandle, int devNumber, int infoType, Pointer infoBuffer,
            IntByReference bufferSize) {
        /* 425 */ throw new NBUException(57);
    }

    public static abstract interface EnumGetDevInfoHandler extends Callback {
        public abstract int invoke(Pointer paramPointer1, int paramInt1, int paramInt2, Pointer paramPointer2,
                IntByReference paramIntByReference);
    }

    public static abstract interface EnumGetDevNumberHandler extends Callback {
        public abstract int invoke(Pointer paramPointer);
    }

    public static abstract interface EnumDevicesDoneHandler extends Callback {
        public abstract void invoke(Pointer paramPointer);
    }

    public static abstract interface EnumDevicesInitHandler extends Callback {
        public abstract int invoke(String paramString, PointerByReference paramPointerByReference);
    }

    public static abstract interface ResetHandler extends Callback {
        public abstract int invoke(Pointer paramPointer);
    }

    public static abstract interface SetPropertyHandler extends Callback {
        public abstract int invoke(Pointer paramPointer1, short paramShort, Pointer paramPointer2, int paramInt);
    }

    public static abstract interface GetPropertyHandler extends Callback {
        public abstract int invoke(Pointer paramPointer1, short paramShort, Pointer paramPointer2,
                IntByReference paramIntByReference);
    }

    public static abstract interface SendByteHandler extends Callback {
        public abstract int invoke(Pointer paramPointer, byte paramByte, boolean paramBoolean);
    }

    public static abstract interface StartPacketSendHandler extends Callback {
        public abstract int invoke(Pointer paramPointer, int paramInt);
    }

    public static abstract interface SetRemainingSizeHandler extends Callback {
        public abstract void invoke(Pointer paramPointer, int paramInt);
    }

    public static abstract interface ReceiveByteHandler extends Callback {
        public abstract int invoke(Pointer paramPointer, ByteByReference paramByteByReference);
    }

    public static abstract interface WaitForPacketStartHandler extends Callback {
        public abstract int invoke(Pointer paramPointer);
    }

    public static abstract interface SetTimeoutHandler extends Callback {
        public abstract int invoke(Pointer paramPointer, int paramInt);
    }

    public static abstract interface ReopenHandler extends Callback {
        public abstract int invoke(Pointer paramPointer);
    }

    public static abstract interface CloseHandler extends Callback {
        public abstract void invoke(Pointer paramPointer);
    }

    public static abstract interface OpenHandler extends Callback {
        public abstract Pointer invoke(String paramString, Pointer paramPointer, int paramInt);
    }

    public static abstract interface TerminateHandler extends Callback {
        public abstract int invoke();
    }

    public static abstract interface InitializeHandler extends Callback {
        public abstract int invoke();
    }
}
