package com.nextbiometrics.devices;

public class NBUException extends RuntimeException {
    private static final long serialVersionUID = 6888081389572028673L;
    private int code;

    public NBUException(int code) {
        /* 17 */ this(code, String.format("NBUERROR 0x%x", new Object[] { Integer.valueOf(code) }));
    }

    public NBUException(int code, String message) {
        /* 21 */ super(message);
        /* 22 */ this.code = code;
    }

    public final int getCode() {
        /* 30 */ return this.code;
    }
}
