package com.nextbiometrics.system;

import com.sun.jna.Pointer;

public abstract class NBObject extends NBAbstractDisposable {
    private Pointer handle;
    private boolean ownsHandle;

    public NBObject(Pointer handle, boolean ownsHandle) {
        /* 18 */ this.handle = handle;
        /* 19 */ this.ownsHandle = ownsHandle;
    }

    public NBObject(Pointer handle) {
        /* 23 */ this(handle, true);
    }

    public final Pointer getHandle() {
        /* 31 */ check();
        /* 32 */ return this.handle;
    }

    public final boolean isDisposed() {
        /* 36 */ return (super.isDisposed()) || (this.handle == null);
    }

    protected final boolean getOwnsHandle() {
        /* 44 */ return this.ownsHandle;
    }

    protected final void check() {
        /* 52 */ super.check();
        /* 53 */ if (this.handle == Pointer.NULL)
            throw new IllegalStateException("Handle is zero");
    }
}
